"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartType = void 0;
exports.getTimeSeriesColor = getTimeSeriesColor;
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ChartType = exports.ChartType = /*#__PURE__*/function (ChartType) {
  ChartType[ChartType["LATENCY_AVG"] = 0] = "LATENCY_AVG";
  ChartType[ChartType["LATENCY_P95"] = 1] = "LATENCY_P95";
  ChartType[ChartType["LATENCY_P99"] = 2] = "LATENCY_P99";
  ChartType[ChartType["THROUGHPUT"] = 3] = "THROUGHPUT";
  ChartType[ChartType["FAILED_TRANSACTION_RATE"] = 4] = "FAILED_TRANSACTION_RATE";
  ChartType[ChartType["CPU_USAGE"] = 5] = "CPU_USAGE";
  ChartType[ChartType["MEMORY_USAGE"] = 6] = "MEMORY_USAGE";
  ChartType[ChartType["SESSIONS"] = 7] = "SESSIONS";
  ChartType[ChartType["HTTP_REQUESTS"] = 8] = "HTTP_REQUESTS";
  ChartType[ChartType["ERROR_OCCURRENCES"] = 9] = "ERROR_OCCURRENCES";
  ChartType[ChartType["LOG_ERROR_RATE"] = 10] = "LOG_ERROR_RATE";
  ChartType[ChartType["LOG_RATE"] = 11] = "LOG_RATE";
  return ChartType;
}({});
const palette = (0, _eui.euiPaletteColorBlind)({
  rotations: 2
});
const timeSeriesColorMap = {
  [ChartType.LATENCY_AVG]: {
    currentPeriodColor: palette[1],
    previousPeriodColor: palette[11]
  },
  [ChartType.LATENCY_P95]: {
    currentPeriodColor: palette[5],
    previousPeriodColor: palette[15]
  },
  [ChartType.LATENCY_P99]: {
    currentPeriodColor: palette[7],
    previousPeriodColor: palette[17]
  },
  [ChartType.THROUGHPUT]: {
    currentPeriodColor: palette[0],
    previousPeriodColor: palette[10]
  },
  [ChartType.FAILED_TRANSACTION_RATE]: {
    currentPeriodColor: palette[7],
    previousPeriodColor: palette[17]
  },
  [ChartType.CPU_USAGE]: {
    currentPeriodColor: palette[3],
    previousPeriodColor: palette[13]
  },
  [ChartType.MEMORY_USAGE]: {
    currentPeriodColor: palette[8],
    previousPeriodColor: palette[18]
  },
  [ChartType.SESSIONS]: {
    currentPeriodColor: palette[3],
    previousPeriodColor: palette[13]
  },
  [ChartType.HTTP_REQUESTS]: {
    currentPeriodColor: palette[2],
    previousPeriodColor: palette[12]
  },
  [ChartType.ERROR_OCCURRENCES]: {
    currentPeriodColor: palette[3],
    previousPeriodColor: palette[13]
  },
  [ChartType.LOG_RATE]: {
    currentPeriodColor: palette[6],
    previousPeriodColor: palette[16]
  },
  [ChartType.LOG_ERROR_RATE]: {
    currentPeriodColor: palette[3],
    previousPeriodColor: palette[13]
  }
};
function getTimeSeriesColor(chartType) {
  return timeSeriesColorMap[chartType];
}