"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataContextMenu = AddDataContextMenu;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_kibana = require("../../../../context/kibana_context/use_kibana");
var _buttons = require("../../../shared/add_data_buttons/buttons");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addData = _i18n.i18n.translate('xpack.apm.addDataContextMenu.link', {
  defaultMessage: 'Add data'
});
function AddDataContextMenu() {
  const [popoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    core: {
      http: {
        basePath
      }
    },
    share: {
      url: {
        locators
      }
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const onboardingLocator = locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  const addApmButtonData = (0, _buttons.addApmDataProps)(onboardingLocator);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "text",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setPopoverOpen(prevState => !prevState),
    "data-test-subj": "apmAddDataHeaderContextMenu"
  }, addData);
  function reportButtonClick(journey) {
    services.telemetry.reportEntityInventoryAddData({
      view: 'add_data_button',
      journey
    });
  }
  const panels = [{
    id: 0,
    title: addData,
    items: [{
      name: _buttons.associateServiceLogsProps.name,
      href: _buttons.associateServiceLogsProps.link,
      'data-test-subj': 'apmAddDataAssociateServiceLogs',
      target: '_blank',
      onClick: () => {
        reportButtonClick('associate_existing_service_logs');
      }
    }, {
      name: _buttons.collectServiceLogsProps.name,
      href: basePath.prepend(_buttons.collectServiceLogsProps.link),
      'data-test-subj': 'apmAddDataCollectServiceLogs',
      onClick: () => {
        reportButtonClick('collect_new_service_logs');
      }
    }, ...(addApmButtonData.link ? [{
      name: addApmButtonData.name,
      href: addApmButtonData.link,
      icon: 'plusInCircle',
      'data-test-subj': 'apmAddDataApmAgent',
      onClick: () => {
        reportButtonClick('add_apm_agent');
      }
    }] : [])]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "integrations-menu",
    button: button,
    isOpen: popoverOpen,
    closePopover: () => setPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  })));
}