"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallLegends = WaterfallLegends;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _legend = require("../../../../shared/charts/timeline/legend");
var _waterfall_helpers = require("./waterfall/waterfall_helpers/waterfall_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LEGEND_LABELS = {
  [_waterfall_helpers.WaterfallLegendType.ServiceName]: _i18n.i18n.translate('xpack.apm.transactionDetails.servicesTitle', {
    defaultMessage: 'Services'
  }),
  [_waterfall_helpers.WaterfallLegendType.SpanType]: _i18n.i18n.translate('xpack.apm.transactionDetails.spanTypeLegendTitle', {
    defaultMessage: 'Type'
  })
};
function WaterfallLegends({
  legends,
  type
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, LEGEND_LABELS[type]))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, legends.map(legend => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: legend.value
  }, /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    color: legend.color,
    text: legend.value
  }))))));
}