"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createJobs = createJobs;
var _i18n = require("@kbn/i18n");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorToastTitle = _i18n.i18n.translate('xpack.apm.anomalyDetection.createJobs.failed.title', {
  defaultMessage: 'Anomaly detection jobs could not be created'
});
const successToastTitle = _i18n.i18n.translate('xpack.apm.anomalyDetection.createJobs.succeeded.title', {
  defaultMessage: 'Anomaly detection jobs created'
});
async function createJobs({
  environments,
  toasts
}) {
  try {
    await (0, _create_call_apm_api.callApmApi)('POST /internal/apm/settings/anomaly-detection/jobs', {
      signal: null,
      params: {
        body: {
          environments
        }
      }
    });
    toasts.addSuccess({
      title: successToastTitle,
      text: getSuccessToastMessage(environments)
    });
    return true;
  } catch (error) {
    toasts.addDanger({
      title: errorToastTitle,
      text: getErrorToastMessage(environments, error)
    });
    return false;
  }
}
function getSuccessToastMessage(environments) {
  return _i18n.i18n.translate('xpack.apm.anomalyDetection.createJobs.succeeded.text', {
    defaultMessage: 'Anomaly detection jobs successfully created for APM service environments [{environments}]. It will take some time for machine learning to start analyzing traffic for anomalies.',
    values: {
      environments: environments.join(', ')
    }
  });
}
function getErrorToastMessage(environments, error) {
  return _i18n.i18n.translate('xpack.apm.anomalyDetection.createJobs.failed.text', {
    defaultMessage: 'Something went wrong when creating one or more anomaly detection jobs for APM service environments [{environments}]. Error: "{errorMessage}"',
    values: {
      environments: environments.join(', '),
      errorMessage: error.message
    }
  });
}