"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInstanceDetailsFetcher = useInstanceDetailsFetcher;
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useInstanceDetailsFetcher({
  serviceName,
  serviceNodeName
}) {
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/overview');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end) {
      return;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/service_overview_instances/details/{serviceNodeName}', {
      params: {
        path: {
          serviceName,
          serviceNodeName
        },
        query: {
          start,
          end
        }
      }
    });
  }, [serviceName, serviceNodeName, start, end]);
  return {
    data,
    status
  };
}