"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticConfigurationForm = DiagnosticConfigurationForm;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _suggestions_select = require("../../../shared/suggestions_select");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DiagnosticConfigurationForm({
  onSelectionUpdate,
  sourceNode
}) {
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/service-map', '/service-map', '/mobile-services/{serviceName}/service-map');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const steps = [{
    title: _i18n.i18n.translate('xpack.apm.serviceMap.diagnoseMissingConnection.title', {
      defaultMessage: 'Configure Missing Nodes'
    }),
    children: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnoseMissingConnection.description', {
      defaultMessage: 'Specify the source and destination services you expect to see connected in the service map.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.apm.serviceMap.diagnoseMissingConnection.sourceNodeLabel', {
        defaultMessage: 'Source node'
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
      dataTestSubj: "sourceNode.value",
      fieldName: 'service.name',
      placeholder: _i18n.i18n.translate('xpack.apm.serviceMap.diagnoseMissingConnection.sourceNodePlaceholder', {
        defaultMessage: 'Select or type source service name'
      }),
      onChange: selectedValue => onSelectionUpdate({
        field: 'sourceNode',
        value: selectedValue
      }),
      defaultValue: sourceNode,
      start: start,
      end: end
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.apm.serviceMap.diagnoseMissingConnection.destinationNodeLabel', {
        defaultMessage: 'Destination node'
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
      dataTestSubj: `destinationNode.value`,
      fieldName: 'service.name',
      placeholder: _i18n.i18n.translate('xpack.apm.serviceMap.diagnoseMissingConnection.destinationNodePlaceholder', {
        defaultMessage: 'Select or type destination service name'
      }),
      onChange: selectedValue => onSelectionUpdate({
        field: 'destinationNode',
        value: selectedValue
      }),
      start: start,
      end: end
    }))))
  }, {
    title: _i18n.i18n.translate('xpack.apm.serviceMap.traceInformation.title', {
      defaultMessage: 'Provide Trace Information'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, _i18n.i18n.translate('xpack.apm.serviceMap.traceInformation.description', {
      defaultMessage: 'Enter a trace ID that is expected to propagate across both the source and destination services'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.apm.serviceMap.traceInformation.traceIdLabel', {
        defaultMessage: 'Trace ID'
      }),
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.serviceMap.diagnoseMissingConnection.destinationNodeOptionalLabel",
        defaultMessage: "Optional"
      }))
    }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
      fieldName: "trace.id",
      onChange: value => onSelectionUpdate({
        field: 'traceId',
        value
      }),
      placeholder: _i18n.i18n.translate('xpack.apm.serviceMap.traceInformation.traceIdPlaceholder', {
        defaultMessage: 'Select or type trace ID'
      }),
      start: start,
      end: end
    })))
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnoseMissingConnection.title', {
    defaultMessage: 'Diagnose a missing connection'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    headingElement: "h2",
    steps: steps
  })));
}