"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertSavedDashboardToPanels = convertSavedDashboardToPanels;
exports.hasDashboard = hasDashboard;
var _dashboard_catalog = require("./dashboards/dashboard_catalog");
var _get_dashboard_file_name = require("./dashboards/get_dashboard_file_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDashboardFileNameFromProps({
  agentName,
  telemetrySdkName,
  telemetrySdkLanguage
}) {
  const dashboardFile = agentName && (0, _get_dashboard_file_name.getDashboardFileName)({
    agentName,
    telemetrySdkName,
    telemetrySdkLanguage
  });
  return dashboardFile;
}
function hasDashboard(props) {
  const dashboardFilename = getDashboardFileNameFromProps(props);
  return !!dashboardFilename && _dashboard_catalog.existingDashboardFileNames.has(dashboardFilename);
}
const getAdhocDataView = dataView => {
  return {
    [dataView.id]: {
      ...dataView
    }
  };
};
async function convertSavedDashboardToPanels(props, dataView) {
  const dashboardFilename = getDashboardFileNameFromProps(props);
  const dashboardJSON = !!dashboardFilename ? await (0, _dashboard_catalog.loadDashboardFile)(dashboardFilename) : false;
  if (!dashboardFilename || !dashboardJSON) {
    return undefined;
  }
  const panelsRawObjects = JSON.parse(dashboardJSON.attributes.panelsJSON);
  const panels = panelsRawObjects.reduce((acc, panel) => {
    var _ref, _state$datasourceStat, _state$datasourceStat2, _state$datasourceStat3, _state$datasourceStat4, _state$datasourceStat5;
    const {
      gridData,
      embeddableConfig,
      panelIndex,
      title
    } = panel;
    const {
      attributes
    } = embeddableConfig;
    const {
      state
    } = attributes;
    const layers = (_ref = (_state$datasourceStat = (_state$datasourceStat2 = state.datasourceStates) === null || _state$datasourceStat2 === void 0 ? void 0 : (_state$datasourceStat3 = _state$datasourceStat2.formBased) === null || _state$datasourceStat3 === void 0 ? void 0 : _state$datasourceStat3.layers) !== null && _state$datasourceStat !== void 0 ? _state$datasourceStat : (_state$datasourceStat4 = state.datasourceStates) === null || _state$datasourceStat4 === void 0 ? void 0 : (_state$datasourceStat5 = _state$datasourceStat4.textBased) === null || _state$datasourceStat5 === void 0 ? void 0 : _state$datasourceStat5.layers) !== null && _ref !== void 0 ? _ref : [];
    acc[gridData.i] = {
      type: panel.type,
      gridData,
      explicitInput: {
        id: panelIndex,
        ...embeddableConfig,
        title,
        attributes: {
          ...attributes,
          references: [],
          state: {
            ...state,
            adHocDataViews: getAdhocDataView(dataView),
            internalReferences: Object.keys(layers).map(layerId => ({
              id: dataView.id,
              name: `indexpattern-datasource-layer-${layerId}`,
              type: 'index-pattern'
            }))
          }
        }
      }
    };
    return acc;
  }, {});
  return panels;
}