"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diagnosticsRoute = void 0;
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _react = _interopRequireDefault(require("react"));
var t = _interopRequireWildcard(require("io-ts"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_apm_route_path = require("../../../hooks/use_apm_route_path");
var _summary_tab = require("./summary_tab");
var _apm_main_template = require("../../routing/templates/apm_main_template");
var _index_templates_tab = require("./index_templates_tab");
var _indices_tab = require("./indices_tab");
var _data_stream_tab = require("./data_stream_tab");
var _index_pattern_settings_tab = require("./index_pattern_settings_tab");
var _import_export_tab = require("./import_export_tab");
var _diagnostics_context = require("./context/diagnostics_context");
var _use_diagnostics = require("./context/use_diagnostics");
var _index_templates_status = require("./summary_tab/index_templates_status");
var _data_streams_status = require("./summary_tab/data_streams_status");
var _indicies_status = require("./summary_tab/indicies_status");
var _apm_documents_tab = require("./apm_documents_tab");
var _use_fetcher = require("../../../hooks/use_fetcher");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const params = t.type({
  query: t.intersection([t.type({
    rangeFrom: t.string,
    rangeTo: t.string
  }), t.partial({
    refreshPaused: t.union([t.literal('true'), t.literal('false')]),
    refreshInterval: t.string,
    kuery: t.string
  })])
});
const diagnosticsRoute = exports.diagnosticsRoute = {
  '/diagnostics': {
    element: /*#__PURE__*/_react.default.createElement(_diagnostics_context.DiagnosticsContextProvider, null, /*#__PURE__*/_react.default.createElement(DiagnosticsTemplate, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null))),
    params,
    children: {
      '/diagnostics': {
        element: /*#__PURE__*/_react.default.createElement(_summary_tab.DiagnosticsSummary, null),
        params
      },
      '/diagnostics/index-pattern-settings': {
        element: /*#__PURE__*/_react.default.createElement(_index_pattern_settings_tab.DiagnosticsIndexPatternSettings, null),
        params
      },
      '/diagnostics/index-templates': {
        element: /*#__PURE__*/_react.default.createElement(_index_templates_tab.DiagnosticsIndexTemplates, null),
        params
      },
      '/diagnostics/data-streams': {
        element: /*#__PURE__*/_react.default.createElement(_data_stream_tab.DiagnosticsDataStreams, null),
        params
      },
      '/diagnostics/indices': {
        element: /*#__PURE__*/_react.default.createElement(_indices_tab.DiagnosticsIndices, null),
        params
      },
      '/diagnostics/documents': {
        element: /*#__PURE__*/_react.default.createElement(_apm_documents_tab.DiagnosticsApmDocuments, null),
        params
      },
      '/diagnostics/import-export': {
        element: /*#__PURE__*/_react.default.createElement(_import_export_tab.DiagnosticsImportExport, null),
        params
      }
    }
  }
};
function DiagnosticsTemplate({
  children
}) {
  var _diagnosticsBundle$di;
  const routePath = (0, _use_apm_route_path.useApmRoutePath)();
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    diagnosticsBundle,
    status
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/diagnostics/*');
  const isCrossCluster = (0, _summary_tab.getIsCrossCluster)(diagnosticsBundle);
  const isLoading = (0, _use_fetcher.isPending)(status);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoObservability",
        size: "xl"
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.diagnostics.loading', {
        defaultMessage: 'Loading diagnostics'
      }))
    });
  }
  const hasAllClusterPrivileges = (_diagnosticsBundle$di = diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.diagnosticsPrivileges.hasAllClusterPrivileges) !== null && _diagnosticsBundle$di !== void 0 ? _diagnosticsBundle$di : true;
  const tabs = [{
    'data-test-subj': 'summary-tab',
    href: router.link('/diagnostics', {
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.diagnostics.tab.summary', {
      defaultMessage: 'Summary'
    }),
    isSelected: routePath === '/diagnostics'
  }, {
    'data-test-subj': 'index-pattern-tab',
    prepend: !(0, _index_pattern_settings_tab.getIsIndexPatternTabOk)(diagnosticsBundle) && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "red"
    }),
    href: router.link('/diagnostics/index-pattern-settings', {
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.diagnostics.tab.index_pattern_settings', {
      defaultMessage: 'Index pattern settings'
    }),
    isSelected: routePath === '/diagnostics/index-pattern-settings',
    isHidden: isCrossCluster || !hasAllClusterPrivileges
  }, {
    'data-test-subj': 'index-templates-tab',
    prepend: !(0, _index_templates_status.getIsIndexTemplateOk)(diagnosticsBundle) && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "red"
    }),
    href: router.link('/diagnostics/index-templates', {
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.diagnostics.tab.index_templates', {
      defaultMessage: 'Index templates'
    }),
    isSelected: routePath === '/diagnostics/index-templates',
    isHidden: isCrossCluster || !hasAllClusterPrivileges
  }, {
    'data-test-subj': 'data-streams-tab',
    prepend: !(0, _data_streams_status.getIsDataStreamTabOk)(diagnosticsBundle) && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "red"
    }),
    href: router.link('/diagnostics/data-streams', {
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.diagnostics.tab.datastreams', {
      defaultMessage: 'Data streams'
    }),
    isSelected: routePath === '/diagnostics/data-streams',
    isHidden: isCrossCluster || !hasAllClusterPrivileges
  }, {
    'data-test-subj': 'indices-tab',
    prepend: !(0, _indicies_status.getIsIndicesTabOk)(diagnosticsBundle) && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "red"
    }),
    href: router.link('/diagnostics/indices', {
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.diagnostics.tab.indices', {
      defaultMessage: 'Indices'
    }),
    isSelected: routePath === '/diagnostics/indices',
    isHidden: isCrossCluster || !hasAllClusterPrivileges
  }, {
    'data-test-subj': 'documents-tab',
    href: router.link('/diagnostics/documents', {
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.diagnostics.tab.apmEvents', {
      defaultMessage: 'Documents'
    }),
    isSelected: routePath === '/diagnostics/documents'
  }, {
    'data-test-subj': 'import-export-tab',
    href: router.link('/diagnostics/import-export', {
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.diagnostics.tab.import_export', {
      defaultMessage: 'Import/Export'
    }),
    isSelected: routePath === '/diagnostics/import-export'
  }].filter(tab => !tab.isHidden);
  return /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, {
    "data-test-subj": "apmDiagnosticsTemplate",
    pageTitle: "Diagnostics",
    environmentFilter: false,
    showServiceGroupSaveButton: false,
    selectedNavButton: "serviceGroups",
    pageHeader: {
      iconType: 'magnifyWithExclamation',
      rightSideItems: [/*#__PURE__*/_react.default.createElement(RefreshButton, null)],
      description: /*#__PURE__*/_react.default.createElement(TemplateDescription, null),
      tabs
    }
  }, children);
}
function TemplateDescription() {
  const {
    isImported,
    setImportedDiagnosticsBundle
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  if (isImported) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: "Displaying results from the uploaded diagnostics report",
      iconType: "exportAction"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmTemplateDescriptionClearBundleButton",
      onClick: () => setImportedDiagnosticsBundle(undefined)
    }, "Clear bundle"));
  }
  return null;
}
function RefreshButton() {
  const {
    isImported,
    refetch
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: isImported,
    "data-test-subj": "apmDiagnosticsTemplateRefreshButton",
    fill: true,
    onClick: refetch
  }, "Refresh");
}