"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectorType = void 0;
exports.getAnomalyDetectorIndex = getAnomalyDetectorIndex;
exports.getAnomalyDetectorType = getAnomalyDetectorType;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AnomalyDetectorType = exports.AnomalyDetectorType = /*#__PURE__*/function (AnomalyDetectorType) {
  AnomalyDetectorType["txLatency"] = "txLatency";
  AnomalyDetectorType["txThroughput"] = "txThroughput";
  AnomalyDetectorType["txFailureRate"] = "txFailureRate";
  return AnomalyDetectorType;
}({});
const detectorIndices = {
  [AnomalyDetectorType.txLatency]: 0,
  [AnomalyDetectorType.txThroughput]: 1,
  [AnomalyDetectorType.txFailureRate]: 2
};
function getAnomalyDetectorIndex(type) {
  return detectorIndices[type];
}
function getAnomalyDetectorType(detectorIndex) {
  let type;
  for (type in detectorIndices) {
    if (detectorIndices[type] === detectorIndex) {
      return type;
    }
  }
  throw new Error('Could not map detector index to type');
}