"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apmConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const apmReusableConfigSchema = _configSchema.schema.object({
  active: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  serverUrl: _configSchema.schema.maybe(_configSchema.schema.uri()),
  secretToken: _configSchema.schema.maybe(_configSchema.schema.string()),
  apiKey: _configSchema.schema.maybe(_configSchema.schema.string()),
  environment: _configSchema.schema.maybe(_configSchema.schema.string()),
  globalLabels: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))
}, {
  unknowns: 'allow'
});
const apmConfigSchema = exports.apmConfigSchema = apmReusableConfigSchema.extends({
  servicesOverrides: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), apmReusableConfigSchema)),
  redactUsers: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: true
  }))
});