"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.archiveMaintenanceWindowRoute = void 0;
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _common = require("../../../../../common");
var _archive = require("../../../../../common/routes/maintenance_window/apis/archive");
var _transforms = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const archiveMaintenanceWindowRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_ALERTING_API_MAINTENANCE_WINDOW_PATH}/{id}/_archive`,
    validate: {
      params: _archive.archiveParamsSchemaV1,
      body: _archive.archiveBodySchemaV1
    },
    security: {
      authz: {
        requiredPrivileges: [`${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.WRITE_MAINTENANCE_WINDOW}`]
      }
    },
    options: {
      access: 'internal'
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForMaintenanceWindow();
    const params = req.params;
    const body = req.body;
    const maintenanceWindowClient = (await context.alerting).getMaintenanceWindowClient();
    const maintenanceWindow = await maintenanceWindowClient.archive({
      id: params.id,
      archive: body.archive
    });
    const response = {
      body: (0, _transforms.transformMaintenanceWindowToResponseV1)(maintenanceWindow)
    };
    return res.ok(response);
  })));
};
exports.archiveMaintenanceWindowRoute = archiveMaintenanceWindowRoute;