"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listAlertTypesRoute = void 0;
var _license_api_access = require("../../lib/license_api_access");
var _common = require("../../../common");
var _track_legacy_route_usage = require("../../lib/track_legacy_route_usage");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const listAlertTypesRoute = (router, licenseState, docLinks, usageCounter, isServerless) => {
  router.get({
    path: `${_common.LEGACY_BASE_ALERT_API_PATH}/list_alert_types`,
    validate: {},
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: isServerless ? 'internal' : 'public',
      summary: 'Get the alert types',
      tags: ['oas-tag:alerting'],
      deprecated: {
        documentationUrl: docLinks.links.alerting.legacyRuleApiDeprecations,
        severity: 'warning',
        reason: {
          type: 'migrate',
          newApiMethod: 'GET',
          newApiPath: '/api/alerting/rule_types'
        }
      }
    }
  }, router.handleLegacyErrors(async function (context, req, res) {
    (0, _license_api_access.verifyApiAccess)(licenseState);
    if (!context.alerting) {
      return res.badRequest({
        body: 'RouteHandlerContext is not registered for alerting'
      });
    }
    (0, _track_legacy_route_usage.trackLegacyRouteUsage)('listAlertTypes', usageCounter);
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    return res.ok({
      body: Array.from(await rulesClient.listRuleTypes())
    });
  }));
};
exports.listAlertTypesRoute = listAlertTypesRoute;