"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleIdsWithGapsRoute = void 0;
var _get_rules_with_gaps = require("../../../../../common/routes/gaps/apis/get_rules_with_gaps");
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleIdsWithGapsRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_ALERTING_GAPS_GET_RULES_API_PATH}`,
    validate: {
      body: _get_rules_with_gaps.getRuleIdsWithGapBodySchemaV1
    },
    options: {
      access: 'internal'
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const body = req.body;
    const result = await rulesClient.getRuleIdsWithGaps(body);
    const response = {
      body: (0, _transforms.transformResponseV1)(result)
    };
    return res.ok(response);
  })));
};
exports.getRuleIdsWithGapsRoute = getRuleIdsWithGapsRoute;