"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fillGapByIdRoute = void 0;
var _fill = require("../../../../../common/routes/gaps/apis/fill");
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _transforms = require("./transforms");
var _transforms2 = require("../../../backfill/apis/schedule/transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fillGapByIdRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_ALERTING_GAPS_FILL_BY_ID_API_PATH}`,
    validate: {
      query: _fill.fillGapByIdQuerySchemaV1
    },
    options: {
      access: 'internal'
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const query = req.query;
    const result = await rulesClient.fillGapById((0, _transforms.transformRequestV1)(query));
    const response = {
      body: (0, _transforms2.transformResponseV1)(result)
    };
    return res.ok(response);
  })));
};
exports.fillGapByIdRoute = fillGapByIdRoute;