"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mgetGaps = void 0;
var _transform_to_gap = require("./transforms/transform_to_gap");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mgetGaps = async ({
  eventLogClient,
  logger,
  params
}) => {
  try {
    const gapsResponse = await eventLogClient.findEventsByDocumentIds(params.docs);
    if (gapsResponse.data.length === 0) return [];
    const gaps = (0, _transform_to_gap.transformToGap)(gapsResponse);
    return gaps;
  } catch (err) {
    logger.error(`Failed to mget gaps by id ${params.docs.map(doc => doc._id).join(',')}: ${err.message}`);
    throw err;
  }
};
exports.mgetGaps = mgetGaps;