"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildGapsFilter = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildGapsFilter = ({
  start,
  end,
  statuses
}) => {
  const baseFilter = 'event.action: gap AND event.provider: alerting';
  const endFilter = end ? `kibana.alert.rule.gap.range <= "${end}"` : null;
  const startFilter = start ? `kibana.alert.rule.gap.range >= "${start}"` : null;
  const statusesFilter = statuses !== null && statuses !== void 0 && statuses.length ? `(${statuses.map(status => `kibana.alert.rule.gap.status : ${status}`).join(' OR ')})` : null;
  return [baseFilter, endFilter, startFilter, statusesFilter].filter(Boolean).join(' AND ');
};
exports.buildGapsFilter = buildGapsFilter;