"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsForNotification = getAlertsForNotification;
var _lodash = require("lodash");
var _alert = require("../alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAlertsForNotification(flappingSettings, actionGroupId, alertDelay, newAlerts = {}, activeAlerts = {}, recoveredAlerts = {}, currentRecoveredAlerts = {}, startedAt) {
  const currentActiveAlerts = {};
  let delayedAlertsCount = 0;
  for (const id of (0, _lodash.keys)(activeAlerts)) {
    const alert = activeAlerts[id];
    alert.incrementActiveCount();
    alert.resetPendingRecoveredCount();
    // do not trigger an action notification if the number of consecutive
    // active alerts is less than the rule alertDelay threshold
    if (alert.getActiveCount() < alertDelay) {
      // remove from new alerts
      delete newAlerts[id];
      delayedAlertsCount += 1;
    } else {
      currentActiveAlerts[id] = alert;
      // if the active count is equal to the alertDelay it is considered a new alert
      if (alert.getActiveCount() === alertDelay) {
        const currentTime = startedAt !== null && startedAt !== void 0 ? startedAt : new Date().toISOString();
        const state = alert.getState();
        // keep the state and update the start time and duration
        alert.replaceState({
          ...state,
          start: currentTime,
          duration: '0'
        });
        newAlerts[id] = alert;
      }
    }
  }
  for (const id of (0, _lodash.keys)(currentRecoveredAlerts)) {
    const alert = recoveredAlerts[id];
    // if alert has not reached the alertDelay threshold don't recover the alert
    const activeCount = alert.getActiveCount();
    if (activeCount > 0 && activeCount < alertDelay) {
      // remove from recovered alerts
      delete recoveredAlerts[id];
      delete currentRecoveredAlerts[id];
    }
    if (flappingSettings.enabled) {
      const flapping = alert.getFlapping();
      if (flapping) {
        alert.incrementPendingRecoveredCount();
        if (alert.getPendingRecoveredCount() < flappingSettings.statusChangeThreshold) {
          var _alert$getLastSchedul;
          // keep the context and previous actionGroupId if available
          const context = alert.getContext();
          const lastActionGroupId = (_alert$getLastSchedul = alert.getLastScheduledActions()) === null || _alert$getLastSchedul === void 0 ? void 0 : _alert$getLastSchedul.group;
          const newAlert = new _alert.Alert(id, alert.toRaw());
          alert.incrementActiveCount();
          // unset the end time in the alert state
          const state = newAlert.getState();
          delete state.end;
          newAlert.replaceState(state);

          // schedule actions for the new active alert
          newAlert.scheduleActions(lastActionGroupId ? lastActionGroupId : actionGroupId, context);
          activeAlerts[id] = newAlert;
          currentActiveAlerts[id] = newAlert;

          // remove from recovered alerts
          delete recoveredAlerts[id];
          delete currentRecoveredAlerts[id];
        } else {
          alert.resetActiveCount();
          alert.resetPendingRecoveredCount();
        }
      } else {
        alert.resetActiveCount();
      }
    } else {
      alert.resetActiveCount();
      alert.resetPendingRecoveredCount();
    }
  }
  return {
    newAlerts,
    activeAlerts,
    currentActiveAlerts,
    recoveredAlerts,
    currentRecoveredAlerts,
    delayedAlertsCount
  };
}