"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "API_KEY_PENDING_INVALIDATION_TYPE", {
  enumerable: true,
  get: function () {
    return _saved_objects.API_KEY_PENDING_INVALIDATION_TYPE;
  }
});
Object.defineProperty(exports, "AlertingAuthorization", {
  enumerable: true,
  get: function () {
    return _authorization.AlertingAuthorization;
  }
});
Object.defineProperty(exports, "AlertingAuthorizationEntity", {
  enumerable: true,
  get: function () {
    return _authorization.AlertingAuthorizationEntity;
  }
});
Object.defineProperty(exports, "AlertingAuthorizationFilterType", {
  enumerable: true,
  get: function () {
    return _authorization.AlertingAuthorizationFilterType;
  }
});
Object.defineProperty(exports, "AlertsClientError", {
  enumerable: true,
  get: function () {
    return _alerts_client.AlertsClientError;
  }
});
Object.defineProperty(exports, "DEFAULT_AAD_CONFIG", {
  enumerable: true,
  get: function () {
    return _types.DEFAULT_AAD_CONFIG;
  }
});
Object.defineProperty(exports, "DEFAULT_ALERTS_ILM_POLICY", {
  enumerable: true,
  get: function () {
    return _alerts_service.DEFAULT_ALERTS_ILM_POLICY;
  }
});
Object.defineProperty(exports, "DEFAULT_ALERTS_ILM_POLICY_NAME", {
  enumerable: true,
  get: function () {
    return _alerts_service.DEFAULT_ALERTS_ILM_POLICY_NAME;
  }
});
Object.defineProperty(exports, "DEFAULT_MAX_EPHEMERAL_ACTIONS_PER_ALERT", {
  enumerable: true,
  get: function () {
    return _config.DEFAULT_MAX_EPHEMERAL_ACTIONS_PER_ALERT;
  }
});
Object.defineProperty(exports, "ECS_COMPONENT_TEMPLATE_NAME", {
  enumerable: true,
  get: function () {
    return _alerts_service.ECS_COMPONENT_TEMPLATE_NAME;
  }
});
Object.defineProperty(exports, "ECS_CONTEXT", {
  enumerable: true,
  get: function () {
    return _alerts_service.ECS_CONTEXT;
  }
});
Object.defineProperty(exports, "InstallShutdownError", {
  enumerable: true,
  get: function () {
    return _alerts_service.InstallShutdownError;
  }
});
Object.defineProperty(exports, "RULE_SAVED_OBJECT_TYPE", {
  enumerable: true,
  get: function () {
    return _saved_objects.RULE_SAVED_OBJECT_TYPE;
  }
});
Object.defineProperty(exports, "ReadOperations", {
  enumerable: true,
  get: function () {
    return _authorization.ReadOperations;
  }
});
Object.defineProperty(exports, "RuleNotifyWhen", {
  enumerable: true,
  get: function () {
    return _common.RuleNotifyWhen;
  }
});
Object.defineProperty(exports, "TOTAL_FIELDS_LIMIT", {
  enumerable: true,
  get: function () {
    return _alerts_service.TOTAL_FIELDS_LIMIT;
  }
});
Object.defineProperty(exports, "VALID_ALERT_INDEX_PREFIXES", {
  enumerable: true,
  get: function () {
    return _alerts_service.VALID_ALERT_INDEX_PREFIXES;
  }
});
Object.defineProperty(exports, "WriteOperations", {
  enumerable: true,
  get: function () {
    return _authorization.WriteOperations;
  }
});
exports.config = void 0;
Object.defineProperty(exports, "createConcreteWriteIndex", {
  enumerable: true,
  get: function () {
    return _alerts_service.createConcreteWriteIndex;
  }
});
Object.defineProperty(exports, "createOrUpdateComponentTemplate", {
  enumerable: true,
  get: function () {
    return _alerts_service.createOrUpdateComponentTemplate;
  }
});
Object.defineProperty(exports, "createOrUpdateIlmPolicy", {
  enumerable: true,
  get: function () {
    return _alerts_service.createOrUpdateIlmPolicy;
  }
});
Object.defineProperty(exports, "createOrUpdateIndexTemplate", {
  enumerable: true,
  get: function () {
    return _alerts_service.createOrUpdateIndexTemplate;
  }
});
Object.defineProperty(exports, "getComponentTemplate", {
  enumerable: true,
  get: function () {
    return _alerts_service.getComponentTemplate;
  }
});
Object.defineProperty(exports, "getDataStreamAdapter", {
  enumerable: true,
  get: function () {
    return _data_stream_adapter.getDataStreamAdapter;
  }
});
Object.defineProperty(exports, "getEsErrorMessage", {
  enumerable: true,
  get: function () {
    return _errors.getEsErrorMessage;
  }
});
Object.defineProperty(exports, "getIndexTemplate", {
  enumerable: true,
  get: function () {
    return _alerts_service.getIndexTemplate;
  }
});
Object.defineProperty(exports, "installWithTimeout", {
  enumerable: true,
  get: function () {
    return _alerts_service.installWithTimeout;
  }
});
Object.defineProperty(exports, "isRuleSnoozed", {
  enumerable: true,
  get: function () {
    return _lib.isRuleSnoozed;
  }
});
Object.defineProperty(exports, "isValidAlertIndexName", {
  enumerable: true,
  get: function () {
    return _alerts_service.isValidAlertIndexName;
  }
});
Object.defineProperty(exports, "parseDuration", {
  enumerable: true,
  get: function () {
    return _lib.parseDuration;
  }
});
exports.plugin = void 0;
Object.defineProperty(exports, "sanitizeBulkErrorResponse", {
  enumerable: true,
  get: function () {
    return _alerts_client.sanitizeBulkErrorResponse;
  }
});
var _config = require("./config");
var _types = require("./types");
var _saved_objects = require("./saved_objects");
var _common = require("../common");
var _lib = require("./lib");
var _errors = require("./lib/errors");
var _authorization = require("./authorization");
var _alerts_service = require("./alerts_service");
var _alerts_client = require("./alerts_client");
var _data_stream_adapter = require("./alerts_service/lib/data_stream_adapter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const plugin = async initContext => {
  const {
    AlertingPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new AlertingPlugin(initContext);
};
exports.plugin = plugin;
const config = exports.config = {
  schema: _config.configSchema,
  exposeToBrowser: {
    rules: {
      run: {
        alerts: {
          max: true
        }
      }
    },
    disabledRuleTypes: true
  },
  deprecations: ({
    renameFromRoot,
    deprecate
  }) => [renameFromRoot('xpack.alerts.healthCheck', 'xpack.alerting.healthCheck', {
    level: 'warning'
  }), renameFromRoot('xpack.alerts.invalidateApiKeysTask.interval', 'xpack.alerting.invalidateApiKeysTask.interval', {
    level: 'warning'
  }), renameFromRoot('xpack.alerts.invalidateApiKeysTask.removalDelay', 'xpack.alerting.invalidateApiKeysTask.removalDelay', {
    level: 'warning'
  }), renameFromRoot('xpack.alerting.defaultRuleTaskTimeout', 'xpack.alerting.rules.run.timeout', {
    level: 'warning'
  }), deprecate('maxEphemeralActionsPerAlert', 'a future version', {
    level: 'warning',
    message: `Configuring "xpack.alerting.maxEphemeralActionsPerAlert" is deprecated and will be removed in a future version. Remove this setting to increase action execution resiliency.`
  })]
};