"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRule = getRule;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _authorization = require("../../../../authorization");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _lib = require("../../../../rules_client/lib");
var _saved_objects = require("../../../../saved_objects");
var _schemas = require("./schemas");
var _rule = require("../../../../data/rule");
var _transforms = require("../../transforms");
var _schemas2 = require("../../schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getRule(context, params) {
  var _context$auditLogger2;
  const {
    id,
    includeLegacyId = false,
    includeSnoozeData = false,
    excludeFromPublicApi = false
  } = params;
  try {
    _schemas.getRuleParamsSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Error validating get data - ${error.message}`);
  }
  const result = await (0, _rule.getRuleSo)({
    savedObjectsClient: context.unsecuredSavedObjectsClient,
    id
  });
  try {
    await context.authorization.ensureAuthorized({
      ruleTypeId: result.attributes.alertTypeId,
      consumer: result.attributes.consumer,
      operation: _authorization.ReadOperations.Get,
      entity: _authorization.AlertingAuthorizationEntity.Rule
    });
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.GET,
      savedObject: {
        type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
        id,
        name: result.attributes.name
      },
      error
    }));
    throw error;
  }
  (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
    action: _audit_events.RuleAuditAction.GET,
    savedObject: {
      type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
      id,
      name: result.attributes.name
    }
  }));
  const ruleType = context.ruleTypeRegistry.get(result.attributes.alertTypeId);
  const ruleDomain = (0, _transforms.transformRuleAttributesToRuleDomain)(result.attributes, {
    id: result.id,
    logger: context.logger,
    ruleType,
    references: result.references,
    includeSnoozeData
  }, context.isSystemAction);

  // Try to validate created rule, but don't throw.
  try {
    _schemas2.ruleDomainSchema.validate(ruleDomain);
  } catch (e) {
    context.logger.warn(`Error validating get rule domain object for id: ${id}, ${e}`);
  }

  // Convert domain rule to rule (Remove certain properties)
  const rule = (0, _transforms.transformRuleDomainToRule)(ruleDomain, {
    isPublic: excludeFromPublicApi,
    includeLegacyId
  });

  // format legacy actions for SIEM rules
  if (result.attributes.consumer === _ruleDataUtils.AlertConsumers.SIEM) {
    const [migratedRule] = await (0, _lib.formatLegacyActions)([rule], {
      savedObjectsClient: context.unsecuredSavedObjectsClient,
      logger: context.logger
    });
    return migratedRule;
  }

  // TODO (http-versioning): Remove this cast, this enables us to move forward
  // without fixing all of other solution types
  return rule;
}