"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findMaintenanceWindows = findMaintenanceWindows;
exports.getStatusFilter = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _esQuery = require("@kbn/es-query");
var _common = require("../../../../../common");
var _transforms = require("../../transforms");
var _maintenance_window = require("../../../../data/maintenance_window");
var _schemas = require("./schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStatusFilter = status => {
  if (!status || status.length === 0) return undefined;
  const statusToQueryMapping = {
    [_common.MaintenanceWindowStatus.Running]: '(maintenance-window.attributes.events: "now")',
    [_common.MaintenanceWindowStatus.Upcoming]: '(not maintenance-window.attributes.events: "now" and maintenance-window.attributes.events > "now")',
    [_common.MaintenanceWindowStatus.Finished]: '(not maintenance-window.attributes.events >= "now" and maintenance-window.attributes.expirationDate >"now")',
    [_common.MaintenanceWindowStatus.Archived]: '(maintenance-window.attributes.expirationDate < "now")'
  };
  const fullQuery = status.map(value => statusToQueryMapping[value]).filter(Boolean).join(' or ');
  return fullQuery ? (0, _esQuery.fromKueryExpression)(fullQuery) : undefined;
};
exports.getStatusFilter = getStatusFilter;
async function findMaintenanceWindows(context, params) {
  const {
    savedObjectsClient,
    logger
  } = context;
  try {
    if (params) {
      _schemas.findMaintenanceWindowsParamsSchema.validate(params);
    }
  } catch (error) {
    throw _boom.default.badRequest(`Error validating find maintenance windows data - ${error.message}`);
  }
  const filter = getStatusFilter(params === null || params === void 0 ? void 0 : params.status);
  try {
    const result = await (0, _maintenance_window.findMaintenanceWindowSo)({
      savedObjectsClient,
      ...(params ? {
        savedObjectsFindOptions: {
          ...(params.page ? {
            page: params.page
          } : {}),
          ...(params.perPage ? {
            perPage: params.perPage
          } : {}),
          ...(params.search ? {
            search: params.search
          } : {}),
          ...(filter ? {
            filter
          } : {})
        }
      } : {})
    });
    return {
      page: result.page,
      perPage: result.per_page,
      total: result.total,
      data: result.saved_objects.map(so => (0, _transforms.transformMaintenanceWindowAttributesToMaintenanceWindow)({
        attributes: so.attributes,
        id: so.id
      }))
    };
  } catch (e) {
    const errorMessage = `Failed to find maintenance window, Error: ${e}`;
    logger.error(errorMessage);
    throw _boom.default.boomify(e, {
      message: errorMessage
    });
  }
}