"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findMaintenanceWindows = findMaintenanceWindows;
var _transform_maintenance_window_response = require("./transform_maintenance_window_response");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function findMaintenanceWindows({
  http,
  page,
  perPage,
  search,
  selectedStatus
}) {
  const res = await http.get(`${_common.INTERNAL_BASE_ALERTING_API_PATH}/rules/maintenance_window/_find`, {
    query: {
      page,
      per_page: perPage,
      search,
      status: selectedStatus
    }
  });
  return {
    maintenanceWindows: res.data.map(_transform_maintenance_window_response.transformMaintenanceWindowResponse),
    total: res.total
  };
}