"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNthByWeekday = void 0;
var _constants = require("../constants");
var _get_weekday_info = require("./get_weekday_info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNthByWeekday = startDate => {
  const {
    isLastOfMonth,
    nthWeekdayOfMonth
  } = (0, _get_weekday_info.getWeekdayInfo)(startDate);
  return `${isLastOfMonth ? '-1' : '+' + nthWeekdayOfMonth}${_constants.ISO_WEEKDAYS_TO_RRULE[startDate.isoWeekday()]}`;
};
exports.getNthByWeekday = getNthByWeekday;