"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEEKDAY_OPTIONS = exports.STATUS_SORT = exports.STATUS_OPTIONS = exports.STATUS_DISPLAY = exports.RRULE_WEEKDAYS_TO_ISO_WEEKDAYS = exports.RECURRENCE_END_OPTIONS = exports.ISO_WEEKDAYS_TO_RRULE = exports.EndsOptions = exports.DEFAULT_PRESETS = exports.DEFAULT_FREQUENCY_OPTIONS = exports.CREATE_FORM_CUSTOM_FREQUENCY = void 0;
var _lodash = require("lodash");
var _rrule = require("@kbn/rrule");
var _moment = _interopRequireDefault(require("moment"));
var i18n = _interopRequireWildcard(require("./translations"));
var _common = require("../../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_FREQUENCY_OPTIONS = exports.DEFAULT_FREQUENCY_OPTIONS = [{
  text: i18n.CREATE_FORM_FREQUENCY_DAILY,
  value: _rrule.Frequency.DAILY
}, {
  text: i18n.CREATE_FORM_FREQUENCY_WEEKLY,
  value: _rrule.Frequency.WEEKLY
}, {
  text: i18n.CREATE_FORM_FREQUENCY_MONTHLY,
  value: _rrule.Frequency.MONTHLY
}, {
  text: i18n.CREATE_FORM_FREQUENCY_YEARLY,
  value: _rrule.Frequency.YEARLY
}, {
  text: i18n.CREATE_FORM_FREQUENCY_CUSTOM,
  value: 'CUSTOM'
}];
const DEFAULT_PRESETS = exports.DEFAULT_PRESETS = {
  [_rrule.Frequency.DAILY]: {
    interval: 1
  },
  [_rrule.Frequency.WEEKLY]: {
    interval: 1
  },
  [_rrule.Frequency.MONTHLY]: {
    interval: 1
  },
  [_rrule.Frequency.YEARLY]: {
    interval: 1
  }
};
let EndsOptions = exports.EndsOptions = /*#__PURE__*/function (EndsOptions) {
  EndsOptions["NEVER"] = "never";
  EndsOptions["ON_DATE"] = "ondate";
  EndsOptions["AFTER_X"] = "afterx";
  return EndsOptions;
}({});
const RECURRENCE_END_OPTIONS = exports.RECURRENCE_END_OPTIONS = [{
  id: 'never',
  label: i18n.CREATE_FORM_ENDS_NEVER
}, {
  id: 'ondate',
  label: i18n.CREATE_FORM_ENDS_ON_DATE
}, {
  id: 'afterx',
  label: i18n.CREATE_FORM_ENDS_AFTER_X
}];
const CREATE_FORM_CUSTOM_FREQUENCY = (interval = 1) => [{
  text: i18n.CREATE_FORM_CUSTOM_FREQUENCY_DAILY(interval),
  value: _rrule.Frequency.DAILY
}, {
  text: i18n.CREATE_FORM_CUSTOM_FREQUENCY_WEEKLY(interval),
  value: _rrule.Frequency.WEEKLY
}, {
  text: i18n.CREATE_FORM_CUSTOM_FREQUENCY_MONTHLY(interval),
  value: _rrule.Frequency.MONTHLY
}, {
  text: i18n.CREATE_FORM_CUSTOM_FREQUENCY_YEARLY(interval),
  value: _rrule.Frequency.YEARLY
}];
exports.CREATE_FORM_CUSTOM_FREQUENCY = CREATE_FORM_CUSTOM_FREQUENCY;
const WEEKDAY_OPTIONS = exports.WEEKDAY_OPTIONS = _common.ISO_WEEKDAYS.map(n => ({
  id: String(n),
  label: (0, _moment.default)().isoWeekday(n).format('ddd')
}));
const ISO_WEEKDAYS_TO_RRULE = exports.ISO_WEEKDAYS_TO_RRULE = {
  1: 'MO',
  2: 'TU',
  3: 'WE',
  4: 'TH',
  5: 'FR',
  6: 'SA',
  7: 'SU'
};
const RRULE_WEEKDAYS_TO_ISO_WEEKDAYS = exports.RRULE_WEEKDAYS_TO_ISO_WEEKDAYS = (0, _lodash.mapValues)((0, _lodash.invert)(ISO_WEEKDAYS_TO_RRULE), v => Number(v));
const STATUS_DISPLAY = exports.STATUS_DISPLAY = {
  [_common.MaintenanceWindowStatus.Running]: {
    color: 'primary',
    label: i18n.TABLE_STATUS_RUNNING
  },
  [_common.MaintenanceWindowStatus.Upcoming]: {
    color: 'warning',
    label: i18n.TABLE_STATUS_UPCOMING
  },
  [_common.MaintenanceWindowStatus.Finished]: {
    color: 'success',
    label: i18n.TABLE_STATUS_FINISHED
  },
  [_common.MaintenanceWindowStatus.Archived]: {
    color: 'default',
    label: i18n.TABLE_STATUS_ARCHIVED
  }
};
const STATUS_SORT = exports.STATUS_SORT = {
  [_common.MaintenanceWindowStatus.Running]: 0,
  [_common.MaintenanceWindowStatus.Upcoming]: 1,
  [_common.MaintenanceWindowStatus.Finished]: 2,
  [_common.MaintenanceWindowStatus.Archived]: 3
};
const STATUS_OPTIONS = exports.STATUS_OPTIONS = [{
  value: _common.MaintenanceWindowStatus.Running,
  name: i18n.TABLE_STATUS_RUNNING
}, {
  value: _common.MaintenanceWindowStatus.Upcoming,
  name: i18n.TABLE_STATUS_UPCOMING
}, {
  value: _common.MaintenanceWindowStatus.Finished,
  name: i18n.TABLE_STATUS_FINISHED
}, {
  value: _common.MaintenanceWindowStatus.Archived,
  name: i18n.TABLE_STATUS_ARCHIVED
}];