"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateMaintenanceWindowForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _eui = require("@elastic/eui");
var _coreUiSettingsCommon = require("@kbn/core-ui-settings-common");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _schema = require("./schema");
var i18n = _interopRequireWildcard(require("../translations"));
var _recurring_schedule = require("./recurring_schedule_form/recurring_schedule");
var _submit_button = require("./submit_button");
var _convert_to_rrule = require("../helpers/convert_to_rrule");
var _common = require("../../../../common");
var _use_create_maintenance_window = require("../../../hooks/use_create_maintenance_window");
var _use_update_maintenance_window = require("../../../hooks/use_update_maintenance_window");
var _use_get_rule_types = require("../../../hooks/use_get_rule_types");
var _kibana_react = require("../../../utils/kibana_react");
var _date_picker_range_field = require("./fields/date_picker_range_field");
var _use_archive_maintenance_window = require("../../../hooks/use_archive_maintenance_window");
var _maintenance_window_category_selection = require("./maintenance_window_category_selection");
var _maintenance_window_scoped_query_switch = require("./maintenance_window_scoped_query_switch");
var _maintenance_window_scoped_query = require("./maintenance_window_scoped_query");
var _UI_TIMEZONE_OPTIONS$;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UseField = (0, _hook_form_lib.getUseField)({
  component: _components.Field
});
const VALID_CATEGORIES = [_coreApplicationCommon.DEFAULT_APP_CATEGORIES.observability.id, _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id, _coreApplicationCommon.DEFAULT_APP_CATEGORIES.management.id];
const useDefaultTimezone = () => {
  const kibanaTz = (0, _kibana_react.useUiSetting)('dateFormat:tz');
  if (!kibanaTz || kibanaTz === 'Browser') {
    var _moment$tz$guess, _moment$tz;
    return {
      defaultTimezone: (_moment$tz$guess = (_moment$tz = _moment.default.tz) === null || _moment$tz === void 0 ? void 0 : _moment$tz.guess()) !== null && _moment$tz$guess !== void 0 ? _moment$tz$guess : 'UTC',
      isBrowser: true
    };
  }
  return {
    defaultTimezone: kibanaTz,
    isBrowser: false
  };
};
const TIMEZONE_OPTIONS = (_UI_TIMEZONE_OPTIONS$ = _coreUiSettingsCommon.TIMEZONE_OPTIONS.map(timezoneOption => ({
  label: timezoneOption
}))) !== null && _UI_TIMEZONE_OPTIONS$ !== void 0 ? _UI_TIMEZONE_OPTIONS$ : [{
  label: 'UTC'
}];
const CreateMaintenanceWindowForm = exports.CreateMaintenanceWindowForm = /*#__PURE__*/_react.default.memo(props => {
  var _initialValue$scopedQ, _initialValue$scopedQ2;
  const {
    onCancel,
    onSuccess,
    initialValue,
    maintenanceWindowId
  } = props;
  const [defaultStartDateValue] = (0, _react.useState)((0, _moment.default)().toISOString());
  const [defaultEndDateValue] = (0, _react.useState)((0, _moment.default)().add(30, 'minutes').toISOString());
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const {
    defaultTimezone,
    isBrowser
  } = useDefaultTimezone();
  const [isScopedQueryEnabled, setIsScopedQueryEnabled] = (0, _react.useState)(!!(initialValue !== null && initialValue !== void 0 && initialValue.scopedQuery));
  const [query, setQuery] = (0, _react.useState)((initialValue === null || initialValue === void 0 ? void 0 : (_initialValue$scopedQ = initialValue.scopedQuery) === null || _initialValue$scopedQ === void 0 ? void 0 : _initialValue$scopedQ.kql) || '');
  const [filters, setFilters] = (0, _react.useState)((initialValue === null || initialValue === void 0 ? void 0 : (_initialValue$scopedQ2 = initialValue.scopedQuery) === null || _initialValue$scopedQ2 === void 0 ? void 0 : _initialValue$scopedQ2.filters) || []);
  const [scopedQueryErrors, setScopedQueryErrors] = (0, _react.useState)([]);
  const hasSetInitialCategories = (0, _react.useRef)(false);
  const categoryIdsHistory = (0, _react.useRef)([]);
  const isEditMode = initialValue !== undefined && maintenanceWindowId !== undefined;
  const onCreateOrUpdateError = (0, _react.useCallback)(error => {
    var _error$body;
    if (!((_error$body = error.body) !== null && _error$body !== void 0 && _error$body.message)) {
      return;
    }
    if ((0, _common.isScopedQueryError)(error.body.message)) {
      setScopedQueryErrors([i18n.CREATE_FORM_SCOPED_QUERY_INVALID_ERROR_MESSAGE]);
    }
  }, []);
  const {
    mutate: createMaintenanceWindow,
    isLoading: isCreateLoading
  } = (0, _use_create_maintenance_window.useCreateMaintenanceWindow)({
    onError: onCreateOrUpdateError
  });
  const {
    mutate: updateMaintenanceWindow,
    isLoading: isUpdateLoading
  } = (0, _use_update_maintenance_window.useUpdateMaintenanceWindow)({
    onError: onCreateOrUpdateError
  });
  const {
    mutate: archiveMaintenanceWindow
  } = (0, _use_archive_maintenance_window.useArchiveMaintenanceWindow)();
  const {
    data: ruleTypes,
    isLoading: isLoadingRuleTypes
  } = (0, _use_get_rule_types.useGetRuleTypes)();
  const transformQueryFilters = filtersToTransform => {
    return filtersToTransform.map(filter => {
      const {
        $state,
        meta,
        ...rest
      } = filter;
      return {
        $state,
        meta,
        query: filter !== null && filter !== void 0 && filter.query ? {
          ...filter.query
        } : {
          ...rest
        }
      };
    });
  };
  const scopedQueryPayload = (0, _react.useMemo)(() => {
    if (!isScopedQueryEnabled) {
      return null;
    }
    if (!query && !filters.length) {
      return null;
    }

    // Wrapping filters in query object here to avoid schema validation failure
    const transformedFilters = transformQueryFilters(filters);
    return {
      kql: query,
      filters: transformedFilters
    };
  }, [isScopedQueryEnabled, query, filters]);
  const submitMaintenanceWindow = (0, _react.useCallback)(async (formData, isValid) => {
    if (!isValid || scopedQueryErrors.length !== 0) {
      return;
    }
    if (isScopedQueryEnabled && !scopedQueryPayload) {
      setScopedQueryErrors([i18n.CREATE_FORM_SCOPED_QUERY_EMPTY_ERROR_MESSAGE]);
      return;
    }
    const startDate = (0, _moment.default)(formData.startDate);
    const endDate = (0, _moment.default)(formData.endDate);
    const maintenanceWindow = {
      title: formData.title,
      duration: endDate.diff(startDate),
      rRule: (0, _convert_to_rrule.convertToRRule)(startDate, formData.timezone ? formData.timezone[0] : defaultTimezone, formData.recurringSchedule),
      categoryIds: formData.categoryIds,
      scopedQuery: scopedQueryPayload
    };
    if (isEditMode) {
      updateMaintenanceWindow({
        maintenanceWindowId,
        updateParams: maintenanceWindow
      }, {
        onSuccess
      });
    } else {
      createMaintenanceWindow(maintenanceWindow, {
        onSuccess
      });
    }
  }, [isEditMode, isScopedQueryEnabled, scopedQueryErrors, maintenanceWindowId, updateMaintenanceWindow, createMaintenanceWindow, onSuccess, defaultTimezone, scopedQueryPayload]);
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: initialValue,
    options: {
      stripEmptyFields: false
    },
    schema: _schema.schema,
    onSubmit: submitMaintenanceWindow
  });
  const [{
    recurring,
    timezone,
    categoryIds
  }, _, mounted] = (0, _hook_form_lib.useFormData)({
    form,
    watch: ['recurring', 'timezone', 'categoryIds', 'scopedQuery']
  });
  const isRecurring = recurring || false;
  const showTimezone = isBrowser || (initialValue === null || initialValue === void 0 ? void 0 : initialValue.timezone) !== undefined;
  const closeModal = (0, _react.useCallback)(() => setIsModalVisible(false), []);
  const showModal = (0, _react.useCallback)(() => setIsModalVisible(true), []);
  const {
    setFieldValue
  } = form;
  const validRuleTypes = (0, _react.useMemo)(() => {
    if (!ruleTypes) {
      return [];
    }
    return ruleTypes.filter(ruleType => VALID_CATEGORIES.includes(ruleType.category));
  }, [ruleTypes]);
  const availableCategories = (0, _react.useMemo)(() => {
    return [...new Set(validRuleTypes.map(ruleType => ruleType.category))];
  }, [validRuleTypes]);
  const ruleTypeIds = (0, _react.useMemo)(() => {
    if (!Array.isArray(validRuleTypes) || !Array.isArray(categoryIds) || !mounted) {
      return [];
    }
    const uniqueRuleTypeIds = new Set();
    validRuleTypes.forEach(ruleType => {
      if (categoryIds.includes(ruleType.category)) {
        uniqueRuleTypeIds.add(ruleType.id);
      }
    });
    return [...uniqueRuleTypeIds];
  }, [validRuleTypes, categoryIds, mounted]);
  const onCategoryIdsChange = (0, _react.useCallback)(ids => {
    if (!categoryIds) {
      return;
    }
    setFieldValue('categoryIds', ids);
  }, [categoryIds, setFieldValue]);
  const onScopeQueryToggle = (0, _react.useCallback)(isEnabled => {
    if (isEnabled) {
      setFieldValue('categoryIds', [(categoryIds === null || categoryIds === void 0 ? void 0 : categoryIds.sort()[0]) || availableCategories.sort()[0]]);
    } else {
      setFieldValue('categoryIds', categoryIdsHistory.current);
    }
    setIsScopedQueryEnabled(isEnabled);
  }, [categoryIds, availableCategories, setFieldValue]);
  const onQueryChange = (0, _react.useCallback)(newQuery => {
    if (scopedQueryErrors.length) {
      setScopedQueryErrors([]);
    }
    setQuery(newQuery);
  }, [scopedQueryErrors]);
  const modal = (0, _react.useMemo)(() => {
    let m;
    if (isModalVisible) {
      m = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        title: i18n.ARCHIVE_TITLE,
        onCancel: closeModal,
        onConfirm: () => {
          closeModal();
          archiveMaintenanceWindow({
            maintenanceWindowId: maintenanceWindowId,
            archive: true
          }, {
            onSuccess
          });
        },
        cancelButtonText: i18n.CANCEL,
        confirmButtonText: i18n.ARCHIVE_TITLE,
        defaultFocusedButton: "confirm",
        buttonColor: "danger"
      }, /*#__PURE__*/_react.default.createElement("p", null, i18n.ARCHIVE_CALLOUT_SUBTITLE));
    }
    return m;
  }, [closeModal, archiveMaintenanceWindow, isModalVisible, maintenanceWindowId, onSuccess]);

  // For create mode, we want to initialize options to the rule type category the
  // user has access
  (0, _react.useEffect)(() => {
    if (isEditMode) {
      return;
    }
    if (!mounted) {
      return;
    }
    if (hasSetInitialCategories.current) {
      return;
    }
    if (!validRuleTypes.length) {
      return;
    }
    setFieldValue('categoryIds', [...new Set(validRuleTypes.map(ruleType => ruleType.category))]);
    hasSetInitialCategories.current = true;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isEditMode, validRuleTypes, mounted]);

  // For edit mode, if a maintenance window => category_ids is not an array, this means
  // the maintenance window was created before the introduction of category filters.
  // For backwards compat we will initialize all options for these.
  (0, _react.useEffect)(() => {
    if (!isEditMode) {
      return;
    }
    if (!mounted) {
      return;
    }
    if (hasSetInitialCategories.current) {
      return;
    }
    if (Array.isArray(categoryIds)) {
      return;
    }
    setFieldValue('categoryIds', VALID_CATEGORIES);
    hasSetInitialCategories.current = true;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isEditMode, categoryIds, mounted]);
  (0, _react.useEffect)(() => {
    if (!isScopedQueryEnabled && Array.isArray(categoryIds)) {
      categoryIdsHistory.current = categoryIds;
    }
  }, [categoryIds, isScopedQueryEnabled]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "title",
    componentProps: {
      'data-test-subj': 'title-field',
      euiFieldProps: {
        autoFocus: true
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.CREATE_FORM_TIMEFRAME_TITLE), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, i18n.CREATE_FORM_TIMEFRAME_DESCRIPTION)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseMultiFields, {
    fields: {
      startDate: {
        path: 'startDate',
        config: {
          label: i18n.CREATE_FORM_SCHEDULE,
          defaultValue: defaultStartDateValue,
          validations: []
        }
      },
      endDate: {
        path: 'endDate',
        config: {
          label: '',
          defaultValue: defaultEndDateValue,
          validations: []
        }
      }
    }
  }, fields => /*#__PURE__*/_react.default.createElement(_date_picker_range_field.DatePickerRangeField, {
    fields: fields,
    timezone: timezone !== null && timezone !== void 0 ? timezone : [defaultTimezone],
    "data-test-subj": "date-field"
  }))), showTimezone ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "timezone",
    config: {
      type: _hook_form_lib.FIELD_TYPES.COMBO_BOX,
      validations: [],
      defaultValue: [defaultTimezone]
    },
    componentProps: {
      'data-test-subj': 'timezone-field',
      id: 'timezone',
      euiFieldProps: {
        fullWidth: true,
        options: TIMEZONE_OPTIONS,
        singleSelection: {
          asPlainText: true
        },
        isClearable: false,
        noSuggestions: false,
        placeholder: '',
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
          htmlFor: 'timezone'
        }, i18n.CREATE_FORM_TIMEZONE)
      }
    }
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "recurring",
    componentProps: {
      'data-test-subj': 'recurring-field'
    }
  })), isRecurring && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_recurring_schedule.RecurringSchedule, {
    "data-test-subj": "recurring-form"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl"
  }), /*#__PURE__*/_react.default.createElement(UseField, {
    path: "scopedQuery"
  }, () => /*#__PURE__*/_react.default.createElement(_maintenance_window_scoped_query_switch.MaintenanceWindowScopedQuerySwitch, {
    checked: isScopedQueryEnabled,
    onEnabledChange: onScopeQueryToggle
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl"
  }), /*#__PURE__*/_react.default.createElement(UseField, {
    path: "categoryIds"
  }, field => /*#__PURE__*/_react.default.createElement(_maintenance_window_category_selection.MaintenanceWindowCategorySelection, {
    isScopedQueryEnabled: isScopedQueryEnabled,
    isLoading: isLoadingRuleTypes,
    selectedCategories: categoryIds || [],
    availableCategories: availableCategories,
    errors: field.errors.map(error => error.message),
    onChange: onCategoryIdsChange
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "scopedQuery"
  }, () => /*#__PURE__*/_react.default.createElement(_maintenance_window_scoped_query.MaintenanceWindowScopedQuery, {
    ruleTypeIds: ruleTypeIds,
    query: query,
    filters: filters,
    isLoading: isLoadingRuleTypes,
    isEnabled: isScopedQueryEnabled,
    errors: scopedQueryErrors,
    onQueryChange: onQueryChange,
    onFiltersChange: setFilters
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl"
  })), isEditMode && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.ARCHIVE_TITLE,
    color: "danger",
    iconType: "trash"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.ARCHIVE_SUBTITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "danger",
    onClick: showModal
  }, i18n.ARCHIVE), modal), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "l",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    size: "s",
    "data-test-subj": "cancelMaintenanceWindow"
  }, i18n.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_submit_button.SubmitButton, {
    isLoading: isCreateLoading || isUpdateLoading,
    editMode: isEditMode
  }))));
});
CreateMaintenanceWindowForm.displayName = 'CreateMaintenanceWindowForm';