"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findRulesRequestQuerySchema = exports.findRulesInternalRequestBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findRulesRequestQuerySchema = exports.findRulesRequestQuerySchema = _configSchema.schema.object({
  per_page: _configSchema.schema.number({
    defaultValue: 10,
    min: 0,
    meta: {
      description: 'The number of rules to return per page.'
    }
  }),
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1,
    meta: {
      description: 'The page number to return.'
    }
  }),
  search: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'An Elasticsearch simple_query_string query that filters the objects in the response.'
    }
  })),
  default_search_operator: _configSchema.schema.oneOf([_configSchema.schema.literal('OR'), _configSchema.schema.literal('AND')], {
    defaultValue: 'OR',
    meta: {
      description: 'The default operator to use for the simple_query_string.'
    }
  }),
  search_fields: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()], {
    meta: {
      description: 'The fields to perform the simple_query_string parsed query against.'
    }
  })),
  sort_field: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Determines which field is used to sort the results. The field must exist in the `attributes` key of the response.'
    }
  })),
  sort_order: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')], {
    meta: {
      description: 'Determines the sort order.'
    }
  })),
  has_reference: _configSchema.schema.maybe(
  // use nullable as maybe is currently broken
  // in config-schema
  _configSchema.schema.nullable(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    id: _configSchema.schema.string()
  }, {
    meta: {
      description: 'Filters the rules that have a relation with the reference objects with a specific type and identifier.'
    }
  }))),
  fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'The fields to return in the `attributes` key of the response.'
    }
  }))),
  filter: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'A KQL string that you filter with an attribute from your saved object. It should look like `savedObjectType.attributes.title: "myTitle"`. However, if you used a direct attribute of a saved object, such as `updatedAt`, you must define your filter, for example, `savedObjectType.updatedAt > 2018-12-22`.'
    }
  })),
  filter_consumers: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'List of consumers to filter.'
    }
  })))
});
const findRulesInternalRequestBodySchema = exports.findRulesInternalRequestBodySchema = _configSchema.schema.object({
  per_page: _configSchema.schema.number({
    defaultValue: 10,
    min: 0
  }),
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  search: _configSchema.schema.maybe(_configSchema.schema.string()),
  default_search_operator: _configSchema.schema.oneOf([_configSchema.schema.literal('OR'), _configSchema.schema.literal('AND')], {
    defaultValue: 'OR'
  }),
  search_fields: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()])),
  sort_field: _configSchema.schema.maybe(_configSchema.schema.string()),
  sort_order: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')])),
  has_reference: _configSchema.schema.maybe(
  // use nullable as maybe is currently broken
  // in config-schema
  _configSchema.schema.nullable(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    id: _configSchema.schema.string()
  }))),
  fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  filter: _configSchema.schema.maybe(_configSchema.schema.string()),
  rule_type_ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  consumers: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});