"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogRateAnalysisEmbeddableFactory = void 0;
var _constants = require("@kbn/aiops-log-rate-analysis/constants");
var _common = require("@kbn/data-views-plugin/common");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _shared_components = require("../../shared_components");
var _initialize_log_rate_analysis_analysis_controls = require("./initialize_log_rate_analysis_analysis_controls");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getLogRateAnalysisEmbeddableFactory = getStartServices => {
  const factory = {
    type: _constants.EMBEDDABLE_LOG_RATE_ANALYSIS_TYPE,
    deserializeState: state => {
      var _state$references;
      const serializedState = (0, _lodash.cloneDeep)(state.rawState);
      // inject the reference
      const dataViewIdRef = (_state$references = state.references) === null || _state$references === void 0 ? void 0 : _state$references.find(ref => ref.name === _constants.LOG_RATE_ANALYSIS_DATA_VIEW_REF_NAME);
      // if the serializedState already contains a dataViewId, we don't want to overwrite it. (Unsaved state can cause this)
      if (dataViewIdRef && serializedState && !serializedState.dataViewId) {
        serializedState.dataViewId = dataViewIdRef === null || dataViewIdRef === void 0 ? void 0 : dataViewIdRef.id;
      }
      return serializedState;
    },
    buildEmbeddable: async (state, buildApi, uuid, parentApi) => {
      var _state$dataViewId;
      const [coreStart, pluginStart] = await getStartServices();
      const timeRangeManager = (0, _presentationPublishing.initializeTimeRange)(state);
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(state);
      const {
        logRateAnalysisControlsApi,
        serializeLogRateAnalysisChartState,
        logRateAnalysisControlsComparators
      } = (0, _initialize_log_rate_analysis_analysis_controls.initializeLogRateAnalysisControls)(state);
      const dataLoading$ = new _rxjs.BehaviorSubject(true);
      const blockingError$ = new _rxjs.BehaviorSubject(undefined);
      const dataViews$ = new _rxjs.BehaviorSubject([await pluginStart.data.dataViews.get((_state$dataViewId = state.dataViewId) !== null && _state$dataViewId !== void 0 ? _state$dataViewId : await pluginStart.data.dataViews.getDefaultId())]);
      const filtersApi = (0, _presentationPublishing.apiPublishesFilters)(parentApi) ? parentApi : undefined;
      const api = buildApi({
        ...timeRangeManager.api,
        ...titleManager.api,
        ...logRateAnalysisControlsApi,
        getTypeDisplayName: () => _i18n.i18n.translate('xpack.aiops.logRateAnalysis.typeDisplayName', {
          defaultMessage: 'log rate analysis'
        }),
        isEditingEnabled: () => true,
        onEdit: async () => {
          try {
            const {
              resolveEmbeddableLogRateAnalysisUserInput
            } = await Promise.resolve().then(() => _interopRequireWildcard(require('./resolve_log_rate_analysis_config_input')));
            const result = await resolveEmbeddableLogRateAnalysisUserInput(coreStart, pluginStart, parentApi, uuid, false, logRateAnalysisControlsApi, undefined, serializeLogRateAnalysisChartState());
            logRateAnalysisControlsApi.updateUserInput(result);
          } catch (e) {
            return Promise.reject();
          }
        },
        dataLoading$,
        blockingError$,
        dataViews$,
        serializeState: () => {
          const dataViewId = logRateAnalysisControlsApi.dataViewId.getValue();
          const references = dataViewId ? [{
            type: _common.DATA_VIEW_SAVED_OBJECT_TYPE,
            name: _constants.LOG_RATE_ANALYSIS_DATA_VIEW_REF_NAME,
            id: dataViewId
          }] : [];
          return {
            rawState: {
              timeRange: undefined,
              ...titleManager.serialize(),
              ...timeRangeManager.serialize(),
              ...serializeLogRateAnalysisChartState()
            },
            references
          };
        }
      }, {
        ...timeRangeManager.comparators,
        ...titleManager.comparators,
        ...logRateAnalysisControlsComparators
      });
      const LogRateAnalysisEmbeddableWrapper = (0, _shared_components.getLogRateAnalysisEmbeddableWrapperComponent)(coreStart, pluginStart);
      const onLoading = v => dataLoading$.next(v);
      const onRenderComplete = () => dataLoading$.next(false);
      const onError = error => blockingError$.next(error);
      return {
        api,
        Component: () => {
          if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
            throw new Error('Parent API does not have execution context');
          }
          const [dataViewId] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.dataViewId);
          const reload$ = (0, _react.useMemo)(() => (0, _presentationPublishing.fetch$)(api).pipe((0, _rxjs.skipWhile)(fetchContext => !fetchContext.isReload), (0, _rxjs.map)(fetchContext => Date.now())), []);
          const timeRange$ = (0, _react.useMemo)(() => (0, _presentationPublishing.fetch$)(api).pipe((0, _rxjs.map)(fetchContext => fetchContext.timeRange), (0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default)), []);
          const lastReloadRequestTime = (0, _useObservable.default)(reload$, Date.now());
          const timeRange = (0, _useObservable.default)(timeRange$, undefined);
          const embeddingOrigin = (0, _presentationPublishing.apiHasExecutionContext)(parentApi) ? parentApi.executionContext.type : undefined;
          return /*#__PURE__*/_react.default.createElement(LogRateAnalysisEmbeddableWrapper, {
            filtersApi: filtersApi,
            dataViewId: dataViewId,
            timeRange: timeRange,
            onLoading: onLoading,
            onRenderComplete: onRenderComplete,
            onError: onError,
            embeddingOrigin: embeddingOrigin,
            lastReloadRequestTime: lastReloadRequestTime
          });
        }
      };
    }
  };
  return factory;
};
exports.getLogRateAnalysisEmbeddableFactory = getLogRateAnalysisEmbeddableFactory;