"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MiniHistogram = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _aiopsLogRateAnalysis = require("@kbn/aiops-log-rate-analysis");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_eui_theme = require("../../hooks/use_eui_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MiniHistogram = ({
  chartData,
  isLoading,
  label,
  barColorOverride,
  barHighlightColorOverride
}) => {
  const {
    charts
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const euiTheme = (0, _use_eui_theme.useEuiTheme)();
  const chartBaseTheme = charts.theme.useChartsBaseTheme();
  const miniHistogramChartTheme = {
    chartMargins: {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    },
    chartPaddings: {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    },
    scales: {
      barsPadding: 0.1
    },
    background: {
      color: 'transparent'
    }
  };
  const cssChartSize = (0, _react2.css)({
    width: '80px',
    height: euiTheme.euiSizeL,
    margin: '0px'
  });
  const cssCenter = (0, _react2.css)({
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center'
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement("div", {
      css: [cssChartSize, cssCenter]
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      mono: true
    }));
  }
  if (!chartData) {
    return /*#__PURE__*/_react.default.createElement("div", {
      css: [cssChartSize, cssCenter]
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.miniHistogram.noDataLabel",
      defaultMessage: "N/A"
    })));
  }
  const barColor = barColorOverride ? [barColorOverride] : undefined;
  const barHighlightColor = barHighlightColorOverride ? [barHighlightColorOverride] : [_aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_HIGHLIGHT_COLOR];
  return /*#__PURE__*/_react.default.createElement("div", {
    css: cssChartSize
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [miniHistogramChartTheme],
    baseTheme: chartBaseTheme,
    showLegend: false,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "doc_count_overall",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'key',
    yAccessors: ['doc_count_overall'],
    data: chartData,
    stackAccessors: [0],
    color: barColor
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: label,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'key',
    yAccessors: ['doc_count_significant_item'],
    data: chartData,
    stackAccessors: [0],
    color: barHighlightColor
  })));
};
exports.MiniHistogram = MiniHistogram;