"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedField = exports.FieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectedField = ({
  fields,
  selectedField,
  setSelectedField
}) => {
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const togglePopover = () => setShowPopover(!showPopover);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiDataGridToolbarControl, {
    "data-test-subj": "aiopsEmbeddableSelectFieldButton",
    onClick: () => togglePopover()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
    iconType: "tokenString"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, selectedField === null || selectedField === void 0 ? void 0 : selectedField.name)));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    closePopover: () => setShowPopover(false),
    isOpen: showPopover,
    button: button,
    className: "unifiedDataTableToolbarControlButton"
  }, /*#__PURE__*/_react.default.createElement(FieldSelector, {
    fields: fields,
    selectedField: selectedField,
    setSelectedField: setSelectedField
  }));
};
exports.SelectedField = SelectedField;
const FieldSelector = ({
  fields,
  selectedField,
  setSelectedField,
  WarningComponent
}) => {
  const fieldOptions = (0, _react.useMemo)(() => fields.map(field => ({
    inputDisplay: field.name,
    value: field
  })), [fields]);
  const label = _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.selectedFieldRowLabel', {
    defaultMessage: 'Selected field'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, WarningComponent !== undefined ? /*#__PURE__*/_react.default.createElement(WarningComponent, null) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": "aiopsEmbeddableMenuSelectedFieldFormRow",
    label: label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    compressed: true,
    "aria-label": label,
    options: fieldOptions,
    disabled: fields.length === 0,
    valueOfSelected: selectedField !== null && selectedField !== void 0 ? selectedField : undefined,
    onChange: setSelectedField
  })));
};
exports.FieldSelector = FieldSelector;