"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fnOperationTypeMapping = exports.SPLIT_FIELD_CARDINALITY_LIMIT = exports.MAX_CHANGE_POINT_CONFIGS = exports.EXCLUDED_CHANGE_POINT_TYPES = exports.DEFAULT_AGG_FUNCTION = exports.COMPOSITE_AGG_SIZE = exports.CHANGE_POINT_TYPES = exports.CHANGE_POINT_DETECTION_EVENT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fnOperationTypeMapping = exports.fnOperationTypeMapping = {
  avg: 'average',
  max: 'max',
  min: 'min',
  sum: 'sum'
};
const DEFAULT_AGG_FUNCTION = exports.DEFAULT_AGG_FUNCTION = 'avg';
const SPLIT_FIELD_CARDINALITY_LIMIT = exports.SPLIT_FIELD_CARDINALITY_LIMIT = 10000;
const COMPOSITE_AGG_SIZE = exports.COMPOSITE_AGG_SIZE = 500;
const CHANGE_POINT_TYPES = exports.CHANGE_POINT_TYPES = {
  DIP: 'dip',
  SPIKE: 'spike',
  DISTRIBUTION_CHANGE: 'distribution_change',
  STEP_CHANGE: 'step_change',
  TREND_CHANGE: 'trend_change',
  STATIONARY: 'stationary',
  NON_STATIONARY: 'non_stationary',
  INDETERMINABLE: 'indeterminable'
};
const EXCLUDED_CHANGE_POINT_TYPES = exports.EXCLUDED_CHANGE_POINT_TYPES = new Set([CHANGE_POINT_TYPES.STATIONARY, CHANGE_POINT_TYPES.NON_STATIONARY, CHANGE_POINT_TYPES.INDETERMINABLE]);
const MAX_CHANGE_POINT_CONFIGS = exports.MAX_CHANGE_POINT_CONFIGS = 6;
const CHANGE_POINT_DETECTION_EVENT = exports.CHANGE_POINT_DETECTION_EVENT = {
  RUN: 'ran_aiops_change_point_detection',
  SUCCESS: 'aiops_change_point_detection_success',
  ERROR: 'aiops_change_point_detection_error'
};