"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCurrentSelectedGroup = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _hooks = require("./hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectSelectedGroup = s => s.logRateAnalysisTable.selectedGroup;
const selectPinnedGroup = s => s.logRateAnalysisTable.pinnedGroup;
const selectCurrentSelectedGroup = (0, _toolkit.createSelector)(selectSelectedGroup, selectPinnedGroup, (selectedGroup, pinnedGroup) => {
  if (selectedGroup) {
    return selectedGroup;
  } else if (pinnedGroup) {
    return pinnedGroup;
  }
});
const useCurrentSelectedGroup = () => (0, _hooks.useAppSelector)(selectCurrentSelectedGroup);
exports.useCurrentSelectedGroup = useCurrentSelectedGroup;