"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aiopsLogRateAnalysisSchemaV3 = void 0;
var _configSchema = require("@kbn/config-schema");
var _schema_v = require("./schema_v2");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const overridesV3 = _configSchema.schema.object({
  loaded: _configSchema.schema.maybe(_configSchema.schema.number()),
  remainingKeywordFieldCandidates: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  remainingTextFieldCandidates: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  significantItems: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_schema_v.significantItem)),
  regroupOnly: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const aiopsLogRateAnalysisSchemaV3 = exports.aiopsLogRateAnalysisSchemaV3 = _configSchema.schema.intersection([_schema_v.aiopsLogRateAnalysisBase, /** Overrides to skip steps of the analysis with existing data */
_configSchema.schema.object({
  overrides: _configSchema.schema.maybe(overridesV3)
})]);