"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.events = exports.GEN_AI_TOKEN_COUNT_EVENT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GEN_AI_TOKEN_COUNT_EVENT = exports.GEN_AI_TOKEN_COUNT_EVENT = {
  eventType: 'gen_ai_token_count',
  schema: {
    actionTypeId: {
      type: 'keyword',
      _meta: {
        description: 'Kibana connector type',
        optional: false
      }
    },
    total_tokens: {
      type: 'integer',
      _meta: {
        description: 'Total token count',
        optional: false
      }
    },
    prompt_tokens: {
      type: 'integer',
      _meta: {
        description: 'Prompt token count',
        optional: false
      }
    },
    completion_tokens: {
      type: 'integer',
      _meta: {
        description: 'Completion token count',
        optional: false
      }
    },
    provider: {
      type: 'keyword',
      _meta: {
        description: 'OpenAI provider',
        optional: true
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'LLM model',
        optional: true
      }
    },
    pluginId: {
      type: 'keyword',
      _meta: {
        description: 'Optional Kibana plugin ID that can be used to filter/aggregate telemetry',
        optional: true
      }
    },
    aggregateBy: {
      type: 'keyword',
      _meta: {
        description: 'Optional field used to group telemetry data by a specific field that is important to the consumer, like a task or conversation ID',
        optional: true
      }
    }
  }
};
const events = exports.events = [GEN_AI_TOKEN_COUNT_EVENT];