"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionExecutionSourceType = void 0;
exports.asBackgroundTaskExecutionSource = asBackgroundTaskExecutionSource;
exports.asEmptySource = asEmptySource;
exports.asHttpRequestExecutionSource = asHttpRequestExecutionSource;
exports.asNotificationExecutionSource = asNotificationExecutionSource;
exports.asSavedObjectExecutionSource = asSavedObjectExecutionSource;
exports.isBackgroundTaskExecutionSource = isBackgroundTaskExecutionSource;
exports.isHttpRequestExecutionSource = isHttpRequestExecutionSource;
exports.isNotificationExecutionSource = isNotificationExecutionSource;
exports.isSavedObjectExecutionSource = isSavedObjectExecutionSource;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ActionExecutionSourceType = exports.ActionExecutionSourceType = /*#__PURE__*/function (ActionExecutionSourceType) {
  ActionExecutionSourceType["SAVED_OBJECT"] = "SAVED_OBJECT";
  ActionExecutionSourceType["HTTP_REQUEST"] = "HTTP_REQUEST";
  ActionExecutionSourceType["NOTIFICATION"] = "NOTIFICATION";
  ActionExecutionSourceType["BACKGROUND_TASK"] = "BACKGROUND_TASK";
  return ActionExecutionSourceType;
}({});
function asHttpRequestExecutionSource(source) {
  return {
    type: ActionExecutionSourceType.HTTP_REQUEST,
    source
  };
}
function asEmptySource(type) {
  return {
    type,
    source: {}
  };
}
function asSavedObjectExecutionSource(source) {
  return {
    type: ActionExecutionSourceType.SAVED_OBJECT,
    source
  };
}
function asNotificationExecutionSource(source) {
  return {
    type: ActionExecutionSourceType.NOTIFICATION,
    source
  };
}
function asBackgroundTaskExecutionSource(source) {
  return {
    type: ActionExecutionSourceType.BACKGROUND_TASK,
    source
  };
}
function isHttpRequestExecutionSource(executionSource) {
  return (executionSource === null || executionSource === void 0 ? void 0 : executionSource.type) === ActionExecutionSourceType.HTTP_REQUEST;
}
function isSavedObjectExecutionSource(executionSource) {
  return (executionSource === null || executionSource === void 0 ? void 0 : executionSource.type) === ActionExecutionSourceType.SAVED_OBJECT;
}
function isNotificationExecutionSource(executionSource) {
  return (executionSource === null || executionSource === void 0 ? void 0 : executionSource.type) === ActionExecutionSourceType.NOTIFICATION;
}
function isBackgroundTaskExecutionSource(executionSource) {
  return (executionSource === null || executionSource === void 0 ? void 0 : executionSource.type) === ActionExecutionSourceType.BACKGROUND_TASK;
}