"use strict";
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Model = exports.UrlTemplate = exports.Endpoint = exports.Availability = exports.Availabilities = exports.Deprecation = exports.Visibility = exports.Stability = exports.TypeAlias = exports.Enum = exports.EnumMember = exports.NoBody = exports.PropertiesBody = exports.ValueBody = exports.ResponseException = exports.Response = exports.Request = exports.Interface = exports.Inherits = exports.Container = exports.InternalTag = exports.ExternalTag = exports.VariantBase = exports.BaseType = exports.Property = exports.LiteralValue = exports.UserDefinedValue = exports.DictionaryOf = exports.UnionOf = exports.ArrayOf = exports.InstanceOf = exports.TypeName = void 0;
/**
 * The name of a type, composed of a simple name and a namespace. Hierarchical namespace elements are separated by
 * a dot, e.g 'cat.cat_aliases'.
 *
 * Builtin namespaces:
 * - "generic" for type names that are generic parameter values from the enclosing type.
 * - "internal" for primitive and builtin types (e.g. Id, IndexName, etc)
 *    Builtin types:
 *    - boolean,
 *    - string,
 *    - number: a 64bits floating point number. Additional types will be added for integers.
 *    - null: the null value. Since JS distinguishes undefined and null, some APIs make use of this value.
 *    - object: used to represent "any". We may forbid it at some point. UserDefinedValue should be used for user data.
 */
class TypeName {
}
exports.TypeName = TypeName;
/**
 * A single value
 */
class InstanceOf {
}
exports.InstanceOf = InstanceOf;
/**
 * An array
 */
class ArrayOf {
}
exports.ArrayOf = ArrayOf;
/**
 * One of several possible types which don't necessarily have a common superclass
 */
class UnionOf {
}
exports.UnionOf = UnionOf;
/**
 * A dictionary (or map).  The key is a string or a number (or a union thereof), possibly through an alias.
 *
 * If `singleKey` is true, then this dictionary can only have a single key. This is a common pattern in ES APIs,
 * used to associate a value to a field name or some other identifier.
 */
class DictionaryOf {
}
exports.DictionaryOf = DictionaryOf;
/**
 * A user defined value. To be used when bubbling a generic parameter up to the top-level class is
 * inconvenient or impossible (e.g. for lists of user-defined values of possibly different types).
 *
 * Clients will allow providing a serializer/deserializer when reading/writing properties of this type,
 * and should also accept raw json.
 *
 * Think twice before using this as it defeats the purpose of a strongly typed API, and deserialization
 * will also require to buffer raw JSON data which may have performance implications.
 */
class UserDefinedValue {
}
exports.UserDefinedValue = UserDefinedValue;
/**
 * A literal value. This is used for tagged unions, where each type member of a union has a 'type'
 * attribute that defines its kind. This metamodel heavily uses this approach with its 'kind' attributes.
 *
 * It may later be used to set a property to a constant value, which is why it accepts not only strings but also
 * other primitive types.
 */
class LiteralValue {
}
exports.LiteralValue = LiteralValue;
/**
 * An interface or request interface property.
 */
class Property {
}
exports.Property = Property;
// ------------------------------------------------------------------------------------------------
/**
 * Common attributes for all type definitions
 */
class BaseType {
}
exports.BaseType = BaseType;
class VariantBase {
}
exports.VariantBase = VariantBase;
class ExternalTag extends VariantBase {
}
exports.ExternalTag = ExternalTag;
class InternalTag extends VariantBase {
}
exports.InternalTag = InternalTag;
class Container extends VariantBase {
}
exports.Container = Container;
/**
 * Inherits clause (aka extends or implements) for an interface or request
 */
class Inherits {
}
exports.Inherits = Inherits;
/**
 * An interface type
 */
class Interface extends BaseType {
}
exports.Interface = Interface;
/**
 * A request type
 */
class Request extends BaseType {
}
exports.Request = Request;
/**
 * A response type
 */
class Response extends BaseType {
}
exports.Response = Response;
class ResponseException {
}
exports.ResponseException = ResponseException;
class ValueBody {
}
exports.ValueBody = ValueBody;
class PropertiesBody {
}
exports.PropertiesBody = PropertiesBody;
class NoBody {
}
exports.NoBody = NoBody;
/**
 * An enumeration member.
 *
 * When enumeration members can become ambiguous when translated to an identifier, the `name` property will be a good
 * identifier name, and `stringValue` will be the string value to use on the wire.
 * See DateMathTimeUnit for an example of this, which have members for "m" (minute) and "M" (month).
 */
class EnumMember {
}
exports.EnumMember = EnumMember;
/**
 * An enumeration
 */
class Enum extends BaseType {
}
exports.Enum = Enum;
/**
 * An alias for an existing type.
 */
class TypeAlias extends BaseType {
}
exports.TypeAlias = TypeAlias;
// ------------------------------------------------------------------------------------------------
var Stability;
(function (Stability) {
    Stability["stable"] = "stable";
    Stability["beta"] = "beta";
    Stability["experimental"] = "experimental";
})(Stability || (exports.Stability = Stability = {}));
var Visibility;
(function (Visibility) {
    Visibility["public"] = "public";
    Visibility["feature_flag"] = "feature_flag";
    Visibility["private"] = "private";
})(Visibility || (exports.Visibility = Visibility = {}));
class Deprecation {
}
exports.Deprecation = Deprecation;
class Availabilities {
}
exports.Availabilities = Availabilities;
class Availability {
}
exports.Availability = Availability;
class Endpoint {
}
exports.Endpoint = Endpoint;
class UrlTemplate {
}
exports.UrlTemplate = UrlTemplate;
class Model {
}
exports.Model = Model;
