"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isExperimentalThemeEnabled = exports.isDefaultTheme = exports.EUI_THEMES = exports.EUI_EXPERIMENTAL_THEME_ENABLED_KEY = void 0;
var _theme = require("./amsterdam/theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EUI_THEMES = exports.EUI_THEMES = [{
  text: 'Amsterdam',
  value: _theme.AMSTERDAM_NAME_KEY,
  provider: _theme.EuiThemeAmsterdam
}];
var isDefaultTheme = exports.isDefaultTheme = function isDefaultTheme(name) {
  return name === _theme.AMSTERDAM_NAME_KEY;
};
var EUI_EXPERIMENTAL_THEME_ENABLED_KEY = exports.EUI_EXPERIMENTAL_THEME_ENABLED_KEY = 'eui-experimental-theme-enabled';
var isExperimentalThemeEnabled = exports.isExperimentalThemeEnabled = function isExperimentalThemeEnabled() {
  if (typeof localStorage !== 'undefined') {
    return localStorage.getItem(EUI_EXPERIMENTAL_THEME_ENABLED_KEY) === 'true';
  }
  return false;
};