"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.keys = exports.TAB = exports.SPACE = exports.SHIFT = exports.PAGE_UP = exports.PAGE_DOWN = exports.META = exports.HOME = exports.F2 = exports.ESCAPE = exports.ENTER = exports.END = exports.CTRL = exports.BACKSPACE = exports.ARROW_UP = exports.ARROW_RIGHT = exports.ARROW_LEFT = exports.ARROW_DOWN = exports.ALT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var ENTER = exports.ENTER = 'Enter';
var SPACE = exports.SPACE = ' ';
var ESCAPE = exports.ESCAPE = 'Escape';
var TAB = exports.TAB = 'Tab';
var BACKSPACE = exports.BACKSPACE = 'Backspace';
var F2 = exports.F2 = 'F2';
var ALT = exports.ALT = 'Alt';
var SHIFT = exports.SHIFT = 'Shift';
var CTRL = exports.CTRL = 'Control';
var META = exports.META = 'Meta'; // Windows, Command, Option

var ARROW_DOWN = exports.ARROW_DOWN = 'ArrowDown';
var ARROW_UP = exports.ARROW_UP = 'ArrowUp';
var ARROW_LEFT = exports.ARROW_LEFT = 'ArrowLeft';
var ARROW_RIGHT = exports.ARROW_RIGHT = 'ArrowRight';
var PAGE_UP = exports.PAGE_UP = 'PageUp';
var PAGE_DOWN = exports.PAGE_DOWN = 'PageDown';
var END = exports.END = 'End';
var HOME = exports.HOME = 'Home';
var keys = exports.keys = /*#__PURE__*/function (keys) {
  keys["ENTER"] = "Enter";
  keys["SPACE"] = " ";
  keys["ESCAPE"] = "Escape";
  keys["TAB"] = "Tab";
  keys["BACKSPACE"] = "Backspace";
  keys["F2"] = "F2";
  keys["ALT"] = "Alt";
  keys["SHIFT"] = "Shift";
  keys["CTRL"] = "Control";
  keys["META"] = "Meta";
  keys["ARROW_DOWN"] = "ArrowDown";
  keys["ARROW_UP"] = "ArrowUp";
  keys["ARROW_LEFT"] = "ArrowLeft";
  keys["ARROW_RIGHT"] = "ArrowRight";
  keys["PAGE_UP"] = "PageUp";
  keys["PAGE_DOWN"] = "PageDown";
  keys["END"] = "End";
  keys["HOME"] = "Home";
  return keys;
}({});