"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTourStyles = exports.euiTourBeaconStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _popover_panel = require("../popover/popover_panel/_popover_panel.styles");
var _tour_footer = require("./_tour_footer.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiTourStyles = exports.euiTourStyles = function euiTourStyles(euiThemeContext) {
  return {
    // Targets EuiPopoverPanel
    euiTour: /*#__PURE__*/(0, _react.css)("[data-popover-arrow='top']{background-color:", (0, _tour_footer._tourFooterBgColor)(euiThemeContext), ";};label:euiTour;")
  };
};
var euiTourBeaconStyles = exports.euiTourBeaconStyles = function euiTourBeaconStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  var beaconSize = euiTheme.size.m;
  var beaconOffset = (0, _global_styling.mathWithUnits)(beaconSize, function (x) {
    return x / -2;
  });
  return {
    // Base
    euiTourBeacon: /*#__PURE__*/(0, _react.css)("pointer-events:none;position:absolute;", _global_styling.euiCanAnimate, "{opacity:0;transition:opacity 0s ", euiTheme.animation[_popover_panel.openAnimationTiming], ";};label:euiTourBeacon;"),
    isOpen: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{opacity:1;};label:isOpen;"),
    // Positions
    right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('top', '50%'), " ", (0, _global_styling.logicalCSS)('left', '-50%'), " ", (0, _global_styling.logicalCSS)('margin-top', beaconOffset), ";;label:right;"),
    left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('top', '50%'), " ", (0, _global_styling.logicalCSS)('right', '-50%'), " ", (0, _global_styling.logicalCSS)('margin-top', beaconOffset), ";;label:left;"),
    top: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('left', '50%'), " ", (0, _global_styling.logicalCSS)('bottom', '-50%'), " ", (0, _global_styling.logicalCSS)('margin-left', beaconOffset), ";;label:top;"),
    bottom: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('left', '50%'), " ", (0, _global_styling.logicalCSS)('top', '-50%'), " ", (0, _global_styling.logicalCSS)('margin-left', beaconOffset), ";;label:bottom;")
  };
};