"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTextColorStyles = void 0;
var _react = require("@emotion/react");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "uacjc5-inherit",
  styles: "color:inherit;label:inherit;"
} : {
  name: "uacjc5-inherit",
  styles: "color:inherit;label:inherit;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiTextColorStyles = exports.euiTextColorStyles = function euiTextColorStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    euiTextColor: /*#__PURE__*/(0, _react.css)(";label:euiTextColor;"),
    default: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.text, ";;label:default;"),
    subdued: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textSubdued, ";;label:subdued;"),
    success: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textSuccess, ";;label:success;"),
    accent: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textAccent, ";;label:accent;"),
    accentSecondary: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textAccentSecondary, ";;label:accentSecondary;"),
    danger: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textDanger, ";;label:danger;"),
    warning: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textWarning, ";;label:warning;"),
    ghost: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.ghost, "!important;;label:ghost;"),
    inherit: _ref,
    customColor: /*#__PURE__*/(0, _react.css)(";label:customColor;") // Handled by `style` tag - this is just here for a className hook
  };
};