"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSkeletonLoading = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _screen_reader_live = require("../accessibility/screen_reader_live");
var _i18n = require("../i18n");
var _react2 = require("@emotion/react");
var _excluded = ["isLoading", "contentAriaLabel", "loadingContent", "loadedContent", "announceLoadingStatus", "announceLoadedStatus", "ariaLiveProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiSkeletonLoading = exports.EuiSkeletonLoading = function EuiSkeletonLoading(_ref) {
  var _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? true : _ref$isLoading,
    contentAriaLabel = _ref.contentAriaLabel,
    _loadingContent = _ref.loadingContent,
    loadedContent = _ref.loadedContent,
    _ref$announceLoadingS = _ref.announceLoadingStatus,
    announceLoadingStatus = _ref$announceLoadingS === void 0 ? false : _ref$announceLoadingS,
    _ref$announceLoadedSt = _ref.announceLoadedStatus,
    announceLoadedStatus = _ref$announceLoadedSt === void 0 ? true : _ref$announceLoadedSt,
    ariaLiveProps = _ref.ariaLiveProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var loadedAriaLive = (0, _i18n.useEuiI18n)('euiSkeletonLoading.loadedAriaText', 'Loaded {contentAriaLabel}', {
    contentAriaLabel: contentAriaLabel
  });
  var loadingAriaLabel = (0, _i18n.useEuiI18n)('euiSkeletonLoading.loadingAriaText', 'Loading {contentAriaLabel}', {
    contentAriaLabel: contentAriaLabel
  });
  var loadingProps = {
    'aria-label': loadingAriaLabel,
    role: 'progressbar'
  };
  var loadingContent = /*#__PURE__*/_react.default.cloneElement(_loadingContent, loadingProps);
  return (0, _react2.jsx)("div", _extends({
    "aria-busy": isLoading,
    "data-test-subj": "euiSkeletonLoadingAriaWrapper"
  }, rest), isLoading ? (0, _react2.jsx)(_react.default.Fragment, null, announceLoadingStatus && (0, _react2.jsx)(_screen_reader_live.EuiScreenReaderLive, ariaLiveProps, loadingAriaLabel), loadingContent) : (0, _react2.jsx)(_react.default.Fragment, null, announceLoadedStatus && (0, _react2.jsx)(_screen_reader_live.EuiScreenReaderLive, ariaLiveProps, loadedAriaLive), loadedContent));
};
EuiSkeletonLoading.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Content to display when loading
       */
  loadingContent: _propTypes.default.element.isRequired,
  /**
       * Content to display when loaded
       */
  loadedContent: _propTypes.default.any.isRequired
};