"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePropsWithComponentDefaults = exports.useComponentDefaults = exports.EuiComponentDefaultsProvider = exports.EuiComponentDefaultsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Declaring as a static const for reference integrity/reducing rerenders
var emptyDefaults = {};

/*
 * Context
 */
var EuiComponentDefaultsContext = exports.EuiComponentDefaultsContext = /*#__PURE__*/(0, _react.createContext)(emptyDefaults);

/*
 * Component
 */

var EuiComponentDefaultsProvider = exports.EuiComponentDefaultsProvider = function EuiComponentDefaultsProvider(_ref) {
  var _ref$componentDefault = _ref.componentDefaults,
    componentDefaults = _ref$componentDefault === void 0 ? emptyDefaults : _ref$componentDefault,
    children = _ref.children;
  return (0, _react2.jsx)(EuiComponentDefaultsContext.Provider, {
    value: componentDefaults
  }, children);
};

/*
 * Hooks
 */
EuiComponentDefaultsProvider.propTypes = {
  componentDefaults: _propTypes.default.shape({
    /**
       * Provide a global configuration for EuiPortal's default insertion position.
       */
    EuiPortal: _propTypes.default.any,
    /**
       * Provide a global configuration for EuiFocusTrap's `gapMode` and `crossFrame` props
       */
    EuiFocusTrap: _propTypes.default.any,
    /**
       * Provide global settings for EuiTablePagination's props that affect page size
       * / the rows per page selection.
       *
       * These defaults will be inherited all table and grid components that utilize EuiTablePagination.
       */
    EuiTablePagination: _propTypes.default.any,
    /**
       * Provide a global configuration for EuiTable's `responsiveBreakpoint` prop. Defaults to `'s'`.
       *
       * Defaults will be inherited by all `EuiBasicTable`s and `EuiInMemoryTable`s.
       */
    EuiTable: _propTypes.default.any
  })
};
var useComponentDefaults = exports.useComponentDefaults = function useComponentDefaults() {
  return (0, _react.useContext)(EuiComponentDefaultsContext);
};

// Merge individual component props with component defaults
var usePropsWithComponentDefaults = exports.usePropsWithComponentDefaults = function usePropsWithComponentDefaults(componentName, props) {
  var _context$componentNam;
  var context = (0, _react.useContext)(EuiComponentDefaultsContext);
  var componentDefaults = (_context$componentNam = context[componentName]) !== null && _context$componentNam !== void 0 ? _context$componentNam : emptyDefaults;
  return (0, _react.useMemo)(function () {
    return _objectSpread(_objectSpread({}, componentDefaults), props);
  }, [componentDefaults, props]);
};