"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiMarkStyles = exports.euiMarkScreenReaderStyles = void 0;
var _react = require("@emotion/react");
var _accessibility = require("../accessibility");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiMarkStyles = exports.euiMarkStyles = function euiMarkStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiMark: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.components.markBackground, ";font-weight:", euiTheme.font.weight.bold, ";color:", euiTheme.colors.text, ";;label:euiMark;")
  };
};
var euiMarkScreenReaderStyles = exports.euiMarkScreenReaderStyles = function euiMarkScreenReaderStyles(highlightStart, highlightEnd) {
  return {
    hasScreenReaderHelpText: /*#__PURE__*/(0, _react.css)("&::before,&::after{", (0, _accessibility.euiScreenReaderOnly)(), ";}&::before{content:' [", highlightStart, "] ';}&::after{content:' [", highlightEnd, "] ';};label:hasScreenReaderHelpText;")
  };
};