"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiLoadingChartStyles = exports.euiLoadingChartBarStyles = exports.BARS_COUNT = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _templateObject;
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "yovxj7-euiLoadingChart",
  styles: "overflow:hidden;display:inline-flex;label:euiLoadingChart;"
} : {
  name: "yovxj7-euiLoadingChart",
  styles: "overflow:hidden;display:inline-flex;label:euiLoadingChart;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiLoadingChartStyles = exports.euiLoadingChartStyles = function euiLoadingChartStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    euiLoadingChart: _ref,
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.base), " gap:", euiTheme.size.xxs, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.l), " gap:", euiTheme.size.xxs, ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.xl), " gap:", euiTheme.size.xs, ";;label:xl;")
  };
};
var BARS_COUNT = exports.BARS_COUNT = 4;
var euiLoadingChartBarStyles = exports.euiLoadingChartBarStyles = function euiLoadingChartBarStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  var nonMonoColors = Object.keys(euiTheme.colors.vis).reduce(function (colors, cur) {
    var isVisColor = cur.match(/euiColorVis[0-9]/);
    if (isVisColor) {
      var color = euiTheme.colors.vis[cur];
      return [].concat(_toConsumableArray(colors), [color]);
    }
    return colors;
  }, []);
  return {
    euiLoadingChart__bar: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', '100%'), " display:inline-block;", _global_styling.euiCanAnimate, "{animation:", barAnimation, " 1s infinite;", outputNthChildCss(function (index) {
      return "animation-delay: 0.".concat(index, "s;");
    }), ";}", _global_styling.euiCantAnimate, "{", outputNthChildCss(function (index) {
      return "transform: translateY(".concat(22 * index, "%);");
    }), ";};label:euiLoadingChart__bar;"),
    nonmono: /*#__PURE__*/(0, _react.css)(outputNthChildCss(function (index) {
      return "background-color: ".concat(nonMonoColors[index]);
    }), ";;label:nonmono;"),
    mono: /*#__PURE__*/(0, _react.css)(outputNthChildCss(function (index) {
      var token = "loadingChartMonoBackground".concat(index);
      var color = euiTheme.components[token];
      return "background-color: ".concat(color);
    }), ";;label:mono;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', euiTheme.size.xxs), " ", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.s), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.m), ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.base), ";;label:xl;")
  };
};

/**
 * Small utility helper for generating nth-child CSS for each bar
 */
var outputNthChildCss = function outputNthChildCss(css) {
  return Array.from({
    length: BARS_COUNT
  }, function (_, index) {
    return "\n  &:nth-child(".concat(index + 1, ") {\n    ").concat(css(index), "\n  }");
  }).join();
};
var barAnimation = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    transform: translateY(0);\n  }\n\n  50% {\n    transform: translateY(66%);\n  }\n\n  100% {\n    transform: translateY(0);\n  }\n"])));