"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiImageWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _inner_text = require("../inner_text");
var _image_wrapper = require("./image_wrapper.styles");
var _image_button = require("./image_button");
var _image_caption = require("./image_caption");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiImageWrapper = exports.EuiImageWrapper = function EuiImageWrapper(_ref) {
  var alt = _ref.alt,
    caption = _ref.caption,
    hasShadow = _ref.hasShadow,
    allowFullScreen = _ref.allowFullScreen,
    float = _ref.float,
    margin = _ref.margin,
    children = _ref.children,
    setIsFullScreen = _ref.setIsFullScreen,
    wrapperProps = _ref.wrapperProps,
    fullScreenIconColor = _ref.fullScreenIconColor,
    isFullWidth = _ref.isFullWidth,
    onFullScreen = _ref.onFullScreen;
  var openFullScreen = function openFullScreen() {
    setIsFullScreen(true);
    onFullScreen === null || onFullScreen === void 0 || onFullScreen(true);
  };
  var classes = (0, _classnames.default)('euiImageWrapper', wrapperProps && wrapperProps.className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _image_wrapper.euiImageWrapperStyles)(euiTheme);
  var cssFigureStyles = [styles.euiImageWrapper, float && styles[float], margin && styles[margin], allowFullScreen && styles.allowFullScreen, isFullWidth && styles.fullWidth, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.css];
  var _useInnerText = (0, _inner_text.useInnerText)(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    optionalCaptionRef = _useInnerText2[0],
    optionalCaptionText = _useInnerText2[1];
  return (0, _react2.jsx)("figure", _extends({
    "aria-label": optionalCaptionText
  }, wrapperProps, {
    className: classes,
    css: cssFigureStyles
  }), allowFullScreen ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_image_button.EuiImageButton, {
    hasAlt: !!alt,
    hasShadow: hasShadow,
    onClick: openFullScreen,
    "data-test-subj": "activateFullScreenButton",
    isFullWidth: isFullWidth,
    fullScreenIconColor: fullScreenIconColor
  }, children)) : children, (0, _react2.jsx)(_image_caption.EuiImageCaption, {
    ref: optionalCaptionRef,
    caption: caption
  }));
};
EuiImageWrapper.propTypes = {
  isFullWidth: _propTypes.default.bool.isRequired,
  setIsFullScreen: _propTypes.default.func.isRequired
};