"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiImageButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _icon = require("../icon");
var _accessibility = require("../accessibility");
var _image_button = require("./image_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["hasAlt", "hasShadow", "children", "onClick", "onKeyDown", "isFullScreen", "isFullWidth", "fullScreenIconColor"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var fullScreenIconColorMap = {
  light: 'ghost',
  dark: 'default'
};
var EuiImageButton = exports.EuiImageButton = function EuiImageButton(_ref) {
  var hasAlt = _ref.hasAlt,
    hasShadow = _ref.hasShadow,
    children = _ref.children,
    onClick = _ref.onClick,
    onKeyDown = _ref.onKeyDown,
    isFullScreen = _ref.isFullScreen,
    isFullWidth = _ref.isFullWidth,
    _ref$fullScreenIconCo = _ref.fullScreenIconColor,
    fullScreenIconColor = _ref$fullScreenIconCo === void 0 ? 'light' : _ref$fullScreenIconCo,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var buttonStyles = (0, _image_button.euiImageButtonStyles)(euiTheme);
  var cssButtonStyles = [buttonStyles.euiImageButton, hasShadow ? buttonStyles.hasShadowHover : buttonStyles.shadowHover, !isFullScreen && isFullWidth && buttonStyles.fullWidth];
  var iconStyles = (0, _image_button.euiImageButtonIconStyles)(euiTheme);
  var cssIconStyles = [iconStyles.euiImageButton__icon, iconStyles.openFullScreen];
  var openFullScreenInstructions = (0, _i18n.useEuiI18n)('euiImageButton.openFullScreen', 'Click to open this image in fullscreen mode');
  var closeFullScreenInstructions = (0, _i18n.useEuiI18n)('euiImageButton.closeFullScreen', 'Press Escape or click to close image fullscreen mode');
  var iconColor = fullScreenIconColorMap[fullScreenIconColor];
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("button", _extends({
    type: "button",
    css: cssButtonStyles,
    onClick: onClick,
    onKeyDown: onKeyDown
  }, rest), isFullScreen &&
  // In fullscreen mode, instructions should come first to allow screen reader
  // users to quickly exit vs. potentially reading out long/unskippable alt text
  (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", null, closeFullScreenInstructions, hasAlt && ' — ')), children, !isFullScreen && (0, _react2.jsx)("div", {
    css: cssIconStyles
  }, (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", null, hasAlt && ' — ', openFullScreenInstructions)), (0, _react2.jsx)(_icon.EuiIcon, {
    type: "fullScreen",
    color: iconColor
  }))));
};
EuiImageButton.propTypes = {
  hasAlt: _propTypes.default.bool.isRequired,
  onClick: _propTypes.default.func.isRequired,
  onKeyDown: _propTypes.default.func,
  isFullWidth: _propTypes.default.bool.isRequired,
  isFullScreen: _propTypes.default.bool
};