"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiRangeTooltipValueStyles = exports.euiRangeTooltipStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _popover = require("../../../services/popover");
var _range = require("./range.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiRangeTooltipStyles = exports.euiRangeTooltipStyles = function euiRangeTooltipStyles(euiThemeContext) {
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    // Base
    euiRangeTooltip: /*#__PURE__*/(0, _react.css)("display:block;position:absolute;inset-inline-start:0;inset-block:0;inline-size:calc(100% - ", range.thumbWidth, ");margin-inline-start:", (0, _global_styling.mathWithUnits)(range.thumbWidth, function (x) {
      return x / 2;
    }), ";pointer-events:none;z-index:", range.thumbZIndex, ";;label:euiRangeTooltip;")
  };
};
var euiRangeTooltipValueStyles = exports.euiRangeTooltipValueStyles = function euiRangeTooltipValueStyles(euiThemeContext) {
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var toolTipBackgroundColor = euiTheme.components.tooltipBackground;
  var borderColor = colorMode === 'DARK' ? toolTipBackgroundColor : 'transparent';
  var arrowSize = euiTheme.size.m;
  var arrowOffset = euiTheme.size.l;
  var arrowStyles = (0, _popover._popoverArrowStyles)(euiThemeContext, arrowSize);
  return {
    euiRangeTooltip__value: /*#__PURE__*/(0, _react.css)("position:absolute;inset-block-start:50%;max-inline-size:", (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 16;
    }), ";padding-block:", euiTheme.size.xxs, ";padding-inline:", euiTheme.size.s, ";transform:translateY(-50%);", (0, _global_styling.euiFontSize)(euiThemeContext, 's'), " line-height:", (0, _global_styling.euiFontSize)(euiThemeContext, 's').lineHeight, ";color:", euiTheme.colors.ghost, ";background-color:", toolTipBackgroundColor, ";border:", euiTheme.border.width.thin, " solid ", toolTipBackgroundColor, ";border:", euiTheme.border.width.thin, " solid ", borderColor, ";border-radius:", euiTheme.border.radius.small, ";&::before{content:'';", arrowStyles._arrowStyles, " inset-block-start:50%;margin-block-start:", (0, _global_styling.mathWithUnits)(arrowSize, function (x) {
      return x / -2;
    }), ";background-color:inherit;border:inherit;};label:euiRangeTooltip__value;"),
    left: /*#__PURE__*/(0, _react.css)("margin-inline-end:", arrowOffset, ";&::before{", arrowStyles.positions.left, " inset-inline-start:100%;};label:left;"),
    right: /*#__PURE__*/(0, _react.css)("margin-inline-start:", arrowOffset, ";&::before{", arrowStyles.positions.right, " inset-inline-end:100%;};label:right;"),
    hasTicks: /*#__PURE__*/(0, _react.css)("inset-block-start:", (0, _global_styling.mathWithUnits)(range.thumbWidth, function (x) {
      return x / 2;
    }), ";;label:hasTicks;")
  };
};