"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeTooltip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _range_tooltip = require("./range_tooltip.styles");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiRangeTooltip = exports.EuiRangeTooltip = function EuiRangeTooltip(_ref) {
  var value = _ref.value,
    valueAppend = _ref.valueAppend,
    valuePrepend = _ref.valuePrepend,
    max = _ref.max,
    min = _ref.min,
    name = _ref.name,
    showTicks = _ref.showTicks;
  // Calculate the left position based on value
  var valuePosition = (0, _react.useMemo)(function () {
    var val = 0;
    if (typeof value === 'number') {
      val = value;
    } else if (typeof value === 'string') {
      val = parseFloat(value);
    }
    var decimal = (val - min) / (max - min);
    // Must be between 0-100%
    var valuePosition = decimal <= 1 ? decimal : 1;
    return valuePosition >= 0 ? valuePosition : 0;
  }, [value, min, max]);

  // Change left/right position based on value (half way point)
  var valuePositionSide = (0, _react.useMemo)(function () {
    return valuePosition > 0.5 ? 'left' : 'right';
  }, [valuePosition]);
  var valuePositionStyle = (0, _react.useMemo)(function () {
    if (valuePositionSide === 'left') {
      return (0, _global_styling.logicalStyles)({
        right: "".concat((1 - valuePosition) * 100, "%")
      });
    } else if (valuePositionSide === 'right') {
      return (0, _global_styling.logicalStyles)({
        left: "".concat(valuePosition * 100, "%")
      });
    }
  }, [valuePosition, valuePositionSide]);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _range_tooltip.euiRangeTooltipStyles)(euiTheme);
  var cssStyles = [styles.euiRangeTooltip];
  var valueStyles = (0, _range_tooltip.euiRangeTooltipValueStyles)(euiTheme);
  var cssValueStyles = [valueStyles.euiRangeTooltip__value, valueStyles[valuePositionSide], showTicks && valueStyles.hasTicks];
  return (0, _react2.jsx)("div", {
    className: "euiRangeTooltip",
    css: cssStyles
  }, (0, _react2.jsx)("output", {
    className: "euiRangeTooltip__value",
    css: cssValueStyles,
    htmlFor: name,
    style: valuePositionStyle
  }, valuePrepend, value, valueAppend));
};
EuiRangeTooltip.propTypes = {
  name: _propTypes.default.string
};