"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeDraggable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _range_draggable = require("./range_draggable.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "showTicks", "lowerPosition", "upperPosition", "onChange", "min", "max", "disabled", "value"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiRangeDraggable = exports.EuiRangeDraggable = function EuiRangeDraggable(_ref) {
  var className = _ref.className,
    showTicks = _ref.showTicks,
    lowerPosition = _ref.lowerPosition,
    upperPosition = _ref.upperPosition,
    onChange = _ref.onChange,
    min = _ref.min,
    max = _ref.max,
    disabled = _ref.disabled,
    value = _ref.value,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var outerStyle = (0, _react.useMemo)(function () {
    return (0, _global_styling.logicalStyles)({
      left: lowerPosition,
      right: "calc(100% - ".concat(upperPosition, " - ").concat(euiTheme.euiTheme.size.base, ")")
    });
  }, [lowerPosition, upperPosition, euiTheme.euiTheme.size.base]);
  var handleChange = (0, _react.useCallback)(function (_ref2, isFirstInteraction) {
    var x = _ref2.x;
    if (disabled) return;
    onChange(x, isFirstInteraction);
  }, [disabled, onChange]);
  var _useMouseMove = (0, _services.useMouseMove)(handleChange),
    _useMouseMove2 = _slicedToArray(_useMouseMove, 2),
    handleMouseDown = _useMouseMove2[0],
    handleInteraction = _useMouseMove2[1];
  var classes = (0, _classnames.default)('euiRangeDraggable', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_range_draggable.euiRangeDraggableStyles);
  var cssStyles = [styles.euiRangeDraggable, showTicks && styles.hasTicks, disabled && styles.disabled];
  var innerStyles = (0, _services.useEuiMemoizedStyles)(_range_draggable.euiRangeDraggableInnerStyles);
  var cssInnerStyles = [innerStyles.euiRangeDraggable__inner, disabled ? styles.disabled : innerStyles.enabled];
  var commonProps = {
    className: classes,
    css: cssStyles,
    role: 'slider',
    'aria-valuemin': min,
    'aria-valuemax': max,
    'aria-valuenow': Number(value[0]),
    'aria-valuetext': "".concat(value[0], ", ").concat(value[1]),
    'aria-disabled': !!disabled,
    tabIndex: !!disabled ? -1 : 0
  };
  return (0, _react2.jsx)("div", _extends({
    style: outerStyle
  }, commonProps, rest), (0, _react2.jsx)("div", {
    className: "euiRangeDraggable__inner",
    css: cssInnerStyles,
    onMouseDown: handleMouseDown,
    onTouchStart: handleInteraction,
    onTouchMove: handleInteraction
  }));
};
EuiRangeDraggable.propTypes = {
  lowerPosition: _propTypes.default.string.isRequired,
  upperPosition: _propTypes.default.string.isRequired,
  onChange: _propTypes.default.func.isRequired
};