"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFormControlLayoutIconsStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _form = require("../form.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "3lf9c4-euiFormControlLayoutIcons",
  styles: "pointer-events:none;display:flex;align-items:center;label:euiFormControlLayoutIcons;"
} : {
  name: "3lf9c4-euiFormControlLayoutIcons",
  styles: "pointer-events:none;display:flex;align-items:center;label:euiFormControlLayoutIcons;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFormControlLayoutIconsStyles = exports.euiFormControlLayoutIconsStyles = function euiFormControlLayoutIconsStyles(euiThemeContext) {
  var _euiFormVariables = (0, _form.euiFormVariables)(euiThemeContext),
    controlPadding = _euiFormVariables.controlPadding,
    controlCompressedPadding = _euiFormVariables.controlCompressedPadding,
    controlDisabledColor = _euiFormVariables.controlDisabledColor;
  return {
    euiFormControlLayoutIcons: _ref,
    uncompressed: "\n      gap: ".concat((0, _global_styling.mathWithUnits)(controlPadding, function (x) {
      return x / 2;
    }), ";\n    "),
    compressed: /*#__PURE__*/(0, _react.css)("gap:", (0, _global_styling.mathWithUnits)(controlCompressedPadding, function (x) {
      return x / 2;
    }), ";;label:compressed;"),
    disabled: /*#__PURE__*/(0, _react.css)("cursor:not-allowed;color:", controlDisabledColor, ";;label:disabled;"),
    position: {
      absolute: {
        absolute: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('vertical', 0), ";;label:absolute;"),
        uncompressed: {
          left: /*#__PURE__*/(0, _react.css)("z-index:1;", (0, _global_styling.logicalCSS)('left', controlPadding), ";;label:left;"),
          right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('right', controlPadding), ";;label:right;")
        },
        compressed: {
          left: /*#__PURE__*/(0, _react.css)("z-index:1;", (0, _global_styling.logicalCSS)('left', controlCompressedPadding), ";;label:left;"),
          right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('right', controlCompressedPadding), ";;label:right;")
        }
      },
      static: {
        static: /*#__PURE__*/(0, _react.css)("position:static;", (0, _global_styling.logicalCSS)('height', '100%'), " align-self:stretch;flex-grow:0;", (0, _global_styling.logicalCSS)('padding-horizontal', '100%'), ";;label:static;"),
        uncompressed: (0, _global_styling.logicalCSS)('padding-horizontal', controlPadding),
        compressed: (0, _global_styling.logicalCSS)('padding-horizontal', controlCompressedPadding)
      }
    }
  };
};