"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFormControlLayoutStyles = exports.euiFormControlLayoutSideNodeStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _form = require("../form.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1w10n1m-inGroup",
  styles: "flex-grow:1;overflow:hidden;label:inGroup;"
} : {
  name: "1w10n1m-inGroup",
  styles: "flex-grow:1;overflow:hidden;label:inGroup;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "1lbfa6m-euiFormControlLayout__childrenWrapper",
  styles: "position:relative;label:euiFormControlLayout__childrenWrapper;"
} : {
  name: "1lbfa6m-euiFormControlLayout__childrenWrapper",
  styles: "position:relative;label:euiFormControlLayout__childrenWrapper;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFormControlLayoutStyles = exports.euiFormControlLayoutStyles = function euiFormControlLayoutStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var form = (0, _form.euiFormVariables)(euiThemeContext);
  return {
    euiFormControlLayout: /*#__PURE__*/(0, _react.css)(";label:euiFormControlLayout;"),
    // Skip the css`` on the default height to avoid generating a className
    uncompressed: "\n      ".concat((0, _global_styling.logicalCSS)('height', form.controlHeight), "\n    "),
    compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', form.controlCompressedHeight), ";;label:compressed;"),
    // Skip the css`` on the default width to avoid generating a className
    formWidth: "\n      ".concat((0, _global_styling.logicalCSS)('max-width', form.maxWidth), "\n      ").concat((0, _global_styling.logicalCSS)('width', '100%'), "\n    "),
    fullWidth: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-width', '100%'), " ", (0, _global_styling.logicalCSS)('width', '100%'), ";;label:fullWidth;"),
    group: {
      group: /*#__PURE__*/(0, _react.css)("display:flex;align-items:stretch;border:", euiTheme.border.width.thin, " solid ", form.borderColor, ";background-color:", form.backgroundColor, ";overflow:hidden;>*{", (0, _global_styling.logicalCSS)('height', '100%'), ";};label:group;"),
      // Skipping css`` to avoid repeated compressed/uncompressed classNames
      uncompressed: "\n        border-radius: ".concat(form.controlBorderRadius, ";\n      "),
      compressed: "\n        border-radius: ".concat(form.controlCompressedBorderRadius, ";\n      ")
    },
    children: {
      euiFormControlLayout__childrenWrapper: _ref2,
      inGroup: _ref,
      prependOnly: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top-right-radius', 'inherit'), " ", (0, _global_styling.logicalCSS)('border-bottom-right-radius', 'inherit'), ";;label:prependOnly;"),
      appendOnly: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top-left-radius', 'inherit'), " ", (0, _global_styling.logicalCSS)('border-bottom-left-radius', 'inherit'), ";;label:appendOnly;")
    }
  };
};
var euiFormControlLayoutSideNodeStyles = exports.euiFormControlLayoutSideNodeStyles = function euiFormControlLayoutSideNodeStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var form = (0, _form.euiFormVariables)(euiThemeContext);
  var uncompressedHeight = (0, _global_styling.mathWithUnits)([form.controlHeight, euiTheme.border.width.thin], function (x, y) {
    return x - y * 2;
  });
  var compressedHeight = (0, _global_styling.mathWithUnits)([form.controlCompressedHeight, euiTheme.border.width.thin], function (x, y) {
    return x - y * 2;
  });
  var buttons = '*:is(.euiButton, .euiButtonEmpty, .euiButtonIcon)';
  var text = '*:is(.euiFormLabel, .euiText)';
  return {
    euiFormControlLayout__side: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', '100%'), " ", (0, _global_styling.euiTextTruncate)('50%'), " flex-shrink:0;display:flex;align-items:center;gap:", euiTheme.size.xs, ";background-color:", form.appendPrependBackground, ";", buttons, "{transform:none!important;&:focus-visible{outline-offset:-", euiTheme.focus.width, ";}}", text, "{cursor:default;overflow:hidden;text-overflow:ellipsis;}&:not(:has(> ", buttons, ":first-child, > *:first-child > ", buttons, ")){", (0, _global_styling.logicalCSS)('padding-left', euiTheme.size.s), ";}&:not(:has(> ", buttons, ":last-child, > *:last-child > ", buttons, ")){", (0, _global_styling.logicalCSS)('padding-right', euiTheme.size.s), ";};label:euiFormControlLayout__side;"),
    append: /*#__PURE__*/(0, _react.css)(";label:append;"),
    prepend: /*#__PURE__*/(0, _react.css)(";label:prepend;"),
    uncompressed: "\n      ".concat(text, " {\n        ").concat((0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.xs), "\n        line-height: ").concat(uncompressedHeight, ";\n      }\n\n      ").concat(buttons, " {\n        ").concat((0, _global_styling.logicalCSS)('height', uncompressedHeight), "\n      }\n\n      .euiButtonIcon {\n        flex-shrink: 0;\n        ").concat((0, _global_styling.logicalCSS)('width', euiTheme.size.xl), "\n      }\n    "),
    compressed: /*#__PURE__*/(0, _react.css)(text, "{", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.xxs), " line-height:", compressedHeight, ";}", buttons, "{", (0, _global_styling.logicalCSS)('height', compressedHeight), ";}.euiButtonIcon{flex-shrink:0;", (0, _global_styling.logicalCSS)('width', euiTheme.size.xl), ";};label:compressed;")
  };
};