"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LAYOUTS = exports.GUTTER_SIZES = exports.EuiFacetGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _facet_group = require("./facet_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "layout", "gutterSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var LAYOUTS = exports.LAYOUTS = ['vertical', 'horizontal'];
var GUTTER_SIZES = exports.GUTTER_SIZES = ['none', 's', 'm', 'l'];
var EuiFacetGroup = exports.EuiFacetGroup = function EuiFacetGroup(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$layout = _ref.layout,
    layout = _ref$layout === void 0 ? 'vertical' : _ref$layout,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'm' : _ref$gutterSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var theme = (0, _services.useEuiTheme)();
  var styles = (0, _facet_group.euiFacetGroupStyles)(theme, layout);
  var cssStyles = [styles.euiFacetGroup, styles[gutterSize], styles[layout]];
  var classes = (0, _classnames.default)('euiFacetGroup', className);
  return (0, _react2.jsx)("div", _extends({
    className: classes,
    css: cssStyles
  }, rest), children);
};
EuiFacetGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Vertically in a column, or horizontally in one wrapping line
       */
  layout: _propTypes.default.any,
  /**
       * Distance between facet buttons.
       * Horizontal layout always adds more distance horizontally between buttons.
       */
  gutterSize: _propTypes.default.any
};